<?php
namespace App\Http\Controllers;

use App\Models\Banner;
use App\Models\Contact;
use App\Models\Donation;
use App\Models\User;
use App\Models\Video;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Storage;

class AdminController extends Controller
{
    // Show login form
    public function adminshowLoginForm()
    {

        return view('admin.login');
    }

    // Handle login
    public function adminlogin(Request $request)
    {

        $credentials = $request->validate([
            'email' => ['required', 'email'],
            'password' => ['required'],
        ]);

        if (Auth::attempt($credentials)) {
            $request->session()->regenerate();
            return redirect()->route('admin.dashboard');
        }

        return back()->withErrors(['email' => 'Invalid credentials']);
    }

    // Show dashboard

    public function dashboard()
{
    $userCount = User::count();
    $contactCount =Contact::count();
    $donationCount =Donation::count();
    $totalDonations =Donation::sum('amount');

    // For bar chart data (example: donations by month)
    $donationsByMonth =Donation::selectRaw('MONTH(created_at) as month, SUM(amount) as total')
        ->groupBy('month')
        ->orderBy('month')
        ->get()
        ->pluck('total', 'month')
        ->toArray();

    return view('admin.dashboard', compact(
        'userCount',
        'contactCount',
        'donationCount',
        'totalDonations',
        'donationsByMonth'
    ));
}

    // Banner: List
    public function index()
    {
        $banners = Banner::all();
        return view('admin.banners.index', compact('banners'));
    }

    // Banner: Create form
    public function create()
    {
        return view('admin.banners.create');
    }

    // Banner: Store
    public function store(Request $request)
    {

        $request->validate([
            'name' => 'required|string|max:255',
            'image' => 'required|image|mimes:jpeg,png,jpg|max:12048',
            'description' => 'nullable|string',
        ]);

      $image = $request->file('image');
$imageName = time().'.'.$image->extension();
$image->move(public_path('banners'), $imageName);

        Banner::create([
            'name' => $request->name,
            'image' =>'banners/'.$imageName,
            'description' => $request->description,
        ]);

        return redirect()->route('banners.index')->with('success', 'Banner created successfully');
    }

    public function edit($id)
    {
        $banner = Banner::findOrFail($id);
        return view('admin.banners.edit', compact('banner'));
    }

    public function update(Request $request, $id)
{
    $request->validate([
        'name' => 'required|string|max:255',
        'image' => 'nullable|image|mimes:jpeg,png,jpg|max:12048',
        'description' => 'nullable|string',
    ]);

    $banner = Banner::findOrFail($id);

    $data = [
        'name' => $request->name,
        'description' => $request->description,
    ];

    if ($request->hasFile('image')) {
        // Delete old image if it exists
        if (file_exists(public_path($banner->image))) {
            unlink(public_path($banner->image));
        }

        // Save new image
        $image = $request->file('image');
        $imageName = time().'.'.$image->extension();
        $image->move(public_path('banners'), $imageName);
        $data['image'] = 'banners/'.$imageName;
    }

    $banner->update($data);

    return redirect()->route('admin.banner')->with('success', 'Banner updated successfully');
}

    // Banner: Delete
    public function destroy($id)
    {
        $banner = Banner::findOrFail($id);
        Storage::disk('public')->delete($banner->image);
        $banner->delete();

        return redirect()->route('admin.banner')->with('success', 'Banner deleted successfully');
    }

    // Video: List
   public function indexVideos(Request $request)
{
    $search = $request->input('search');

    $videos = Video::when($search, function ($query, $search) {
            return $query->where('category', 'like', "%{$search}%")
                        ->orWhere('heading', 'like', "%{$search}%")
                        ->orWhere('description', 'like', "%{$search}%")
                        ->orWhere('video_url', 'like', "%{$search}%")
                        ->orWhere('date_time', 'like', "%{$search}%");
        })
        ->orderBy('created_at', 'desc')
        ->paginate(10); // 10 items per page
 $videos = Video::all();
    $videoCount = $videos->count();
    return view('admin.videos.index', compact('videos'));
}

    // Video: Create form
    public function createVideos()
    {
        return view('admin.videos.create');
    }

    // Video: Store
    public function storeVideos(Request $request)
    {
        $request->validate([
            'category' => 'required|in:first,second',
            'hightlight' => 'required|in:0,1',
            'heading' => 'required|string|max:255',
            'video_url' => 'required|url',
            'date_time' => 'required|date',
            'description' => 'nullable|string',
        ]);

        Video::create($request->all());

        return redirect()->route('admin.video')->with('success', 'Video created successfully');
    }
    public function editVideos($id)
    {
        $video = Video::findOrFail($id);
        return view('admin.videos.edit', compact('video'));
    }

    // Video: Update
    public function updateVideos(Request $request, $id)
    {
        $request->validate([
            'category' => 'required|in:first,second',
            'heading' => 'required|string|max:255',
            'video_url' => 'required|url',
            'date_time' => 'required|date',
            'description' => 'nullable|string',
        ]);

        $video = Video::findOrFail($id);
        $video->update($request->all());

        return redirect()->route('admin.video')->with('success', 'Video updated successfully');
    }

    // Video: Delete
    public function destroyVideos($id)
    {
        $video = Video::findOrFail($id);
        $video->delete();

        return redirect()->route('admin.video')->with('success', 'Video deleted successfully');
    }

    // Logout
    public function logout(Request $request)
    {
        Auth::logout();
        $request->session()->invalidate();
        $request->session()->regenerateToken();
        return redirect()->route('admin.login');
    }


     public function admindonationshow()
    {
        $donations = Donation::orderBy('created_at', 'desc')->get();
        return view('admin.donations.index', compact('donations'));
    }
}
