<?php
// app/Http/Controllers/BannerController.php
namespace App\Http\Controllers;

use App\Models\Banner;
use Illuminate\Http\Request;

class BannerController extends Controller
{
    public function index()
    {
        $banners = Banner::all();
        return view('banners.index', compact('banners'));
    }

    public function create()
    {
        return view('banners.create');
    }

    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required',
            'image' => 'required|image|mimes:jpeg,png,jpg,gif|max:2048',
            'description' => 'nullable',
        ]);

        $imageName = time().'.'.$request->image->extension();
        $request->image->move(public_path('uploads/banners'), $imageName);

        Banner::create([
            'name' => $request->name,
            'image' => 'uploads/banners/'.$imageName,
            'description' => $request->description,
        ]);

        return redirect()->route('banners.index')->with('success','Banner created successfully.');
    }

    public function edit(Banner $banner)
    {
        return view('banners.edit', compact('banner'));
    }

    public function update(Request $request, Banner $banner)
    {
        $request->validate([
            'name' => 'required',
            'image' => 'nullable|image|mimes:jpeg,png,jpg,gif|max:2048',
            'description' => 'nullable',
        ]);

        if($request->hasFile('image')) {
            // Delete old image
            if(file_exists(public_path($banner->image))) {
                unlink(public_path($banner->image));
            }

            $imageName = time().'.'.$request->image->extension();
            $request->image->move(public_path('uploads/banners'), $imageName);
            $banner->image = 'uploads/banners/'.$imageName;
        }

        $banner->name = $request->name;
        $banner->description = $request->description;
        $banner->save();

        return redirect()->route('banners.index')->with('success','Banner updated successfully.');
    }

    public function destroy(Banner $banner)
    {
        if(file_exists(public_path($banner->image))) {
            unlink(public_path($banner->image));
        }
        $banner->delete();
        return redirect()->route('banners.index')->with('success','Banner deleted successfully.');
    }
}
