<?php

namespace App\Http\Controllers;

use App\Models\Contact;
use Illuminate\Http\Request;

class ContactController extends Controller
{
    /**
     * Display a listing of all contact form submissions
     */
    public function index()
    {
        $contacts = Contact::orderBy('created_at', 'desc')->get();
        return view('admin.contact', compact('contacts'));
    }

    /**
     * Display the specified contact form submission
     */
    public function show(Contact $contact)
    {
        return view('admin.conshow', compact('contact'));
    }

    /**
     * Mark a contact message as read
     */
    public function markAsRead(Contact $contact)
    {
        if (!$contact->read_at) {
            $contact->update(['read_at' => now()]);
            return back()->with('success', 'Message marked as read');
        }
        return back();
    }

    /**
     * Remove the specified contact form submission
     */
    public function destroy(Contact $contact)
    {
        $contact->delete();
        return redirect()->route('admin.contacts.index')
            ->with('success', 'Contact message deleted successfully');
    }

    /**
     * Store a newly created contact form submission (for frontend form)
     */
    public function store(Request $request)
    {
        $validated = $request->validate([
            'name' => 'required|string|max:255',
            'email' => 'required|email|max:255',
            'phone' => 'required|string|max:20',
            'message' => 'required|string'
        ]);

        Contact::create($validated);

        return back()->with('success', 'Thank you for contacting us! We will get back to you soon.');
    }
}
