<?php
namespace App\Http\Controllers;

use App\Mail\ContactFormMail;
use App\Models\Banner;
use App\Models\Contact;
use App\Models\Video;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Http;


class VideoController extends Controller
{

// app/Http/Controllers/VideoController.php
public function homepage()
{



    return view('index', [
    'videos' => Video::whereNotNull('video_url')
                   ->where('highlight', 1)  // Fixed typo: 'hightlight' → 'highlight'
                   ->latest()
                   ->take(6)
                   ->get(),
                    'latestvideos' => Video::whereNotNull('video_url')
                   ->latest()
                   ->take(6)
                   ->get(),
    'banners' => Banner::all()
]);
}
   public function index(Request $request)
{
    $currentYear = Carbon::now()->year;
    $selectedYear = $request->input('year', $currentYear);
    $selectedMonth = $request->input('month', 'all');
    $fromDate = $request->input('from_date');
    $toDate = $request->input('to_date');

    // Get available years from videos
    $years = Video::selectRaw('YEAR(date_time) as year')
        ->distinct()
        ->pluck('year')
        ->sortDesc()
        ->values();

    // Default years if no videos exist
    $years = $years->isEmpty() ? collect([2025, 2024, 2023, 2022]) : $years;

    // Build video query
    $query = Video::query();

    // Apply filters based on what's provided
    if ($fromDate || $toDate) {
        // Date range takes precedence
        if ($fromDate) {
            $query->whereDate('date_time', '>=', Carbon::parse($fromDate));
        }
        if ($toDate) {
            $query->whereDate('date_time', '<=', Carbon::parse($toDate));
        }
        if (!$fromDate && !$toDate) {
        $query->whereYear('date_time', $selectedYear);
        if ($selectedMonth !== 'all') {
            $query->whereMonth('date_time', $selectedMonth);
        }
    }
    } else {
        // Regular year/month filtering
        $query->whereYear('date_time', $selectedYear);
        if ($selectedMonth !== 'all') {
            $query->whereMonth('date_time', $selectedMonth);
        }
    }

    // Get filtered videos
    $videos = $query->orderBy('highlight', 'desc')
                   ->orderBy('date_time', 'desc')
                   ->get();

    // Months for filter tabs
    $months = [
        'all' => 'All',
        '1' => 'January',
        '2' => 'February',
        '3' => 'March',
        '4' => 'April',
        '5' => 'May',
        '6' => 'June',
        '7' => 'July',
        '8' => 'August',
        '9' => 'September',
        '10' => 'October',
        '11' => 'November',
        '12' => 'December',
    ];

    // For AJAX requests
    if ($request->ajax()) {
        return response()->json([
            'html' => view('users.videos.video_list', compact('videos'))->render(),
            'selectedYear' => $selectedYear,
            'selectedMonth' => $selectedMonth,
            'fromDate' => $fromDate,
            'toDate' => $toDate
        ]);
    }

    // For full page loads
    return view('users.videos.index', compact(
        'videos',
        'years',
        'selectedYear',
        'selectedMonth',
        'months',
        'fromDate',
        'toDate'
    ));
}

public function about()
{
    return view('about');
}

public function contact()
{
    return view('contact');
}
public function contactSave(Request $request)
{

    $validated = $request->validate([
        'name' => 'required|string|max:255',
        'phone' => 'required',
        'email' => 'required|email',
        'message' => 'required|string',
        'g-recaptcha-response' => 'required',
    ]);

    $captchaResponse = Http::asForm()->post('https://www.google.com/recaptcha/api/siteverify', [
        'secret'   => config('services.recaptcha.secret_key'),
        'response' => $request->input('g-recaptcha-response'),
        'remoteip' => $request->ip(),
    ]);

    $captchaData = $captchaResponse->json();

    if (!($captchaData['success'] ?? false)) {
        return back()
            ->withErrors(['captcha' => 'Please verify that you are not a robot.'])
            ->withInput();
    }
    
    // Save to database
    $contact = Contact::create($validated);

    // Send mail to admin
    Mail::to('rckedi1013@gmail.com')->send(new ContactFormMail($validated));

    return back()->with('success', 'Message sent successfully!');
}
}
