<?php
namespace App\Http\Middleware;

use Closure;
use Illuminate\Support\Facades\App;

class Language
{
    public function handle($request, Closure $next)
    {
        $locale = $request->session()->get('locale', config('app.locale'));
        if (in_array($locale, ['en', 'ta'])) {
            App::setLocale($locale);
        }
        return $next($request);
    }
}
