<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Video extends Model
{
   protected $fillable = ['category','highlight', 'heading', 'video_url', 'date_time', 'description'];

   // In your Video model
// app/Models/Video.php
// public function getYoutubeIdAttribute()
// {
//     preg_match('/^(?:https?:\/\/)?(?:www\.)?(?:youtu\.be\/|youtube\.com\/(?:embed\/|v\/|watch\?v=|watch\?.+&v=))((\w|-){11})(?:\S+)?$/', $this->video_url, $matches);
//     return $matches[1] ?? null;

// }
public function getYoutubeIdAttribute()
{
    preg_match('/^(?:https?:\/\/)?(?:www\.)?(?:youtu\.be\/|youtube\.com\/(?:embed\/|v\/|shorts\/|watch\?v=|watch\?.+&v=))((\w|-){11})(?:\S+)?$/', $this->video_url, $matches);
    return $matches[1] ?? null;
}
}
