<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::create('donations', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained()->onDelete('cascade');
            $table->decimal('amount', 10, 2);
            $table->string('transaction_id')->nullable();
            $table->string('payment_gateway'); // 'stripe' or 'razorpay'
            $table->string('status')->default('pending'); // pending, completed, failed
            $table->string('name');
            $table->string('email');
            $table->string('phone');
            $table->text('address');
            $table->string('state');
            $table->string('city');
            $table->string('pincode');
            $table->timestamps();
        });
    }

    public function down()
    {
        Schema::dropIfExists('donations');
    }
};
