(function ($) {
  "use strict";
  document.addEventListener("DOMContentLoaded", () => {
    document.querySelectorAll(".audio-player").forEach((player, index) => {
      const waveformEl = player.querySelector(".waveform");
      const playBtn = player.querySelector(".play-btn");
      const backBtn = player.querySelector(".backward-btn");
      const forwardBtn = player.querySelector(".forward-btn");
      const currentTimeEl = player.querySelector(".current-time");
      const durationTimeEl = player.querySelector(".duration-time");
      const volumeSlider = player.querySelector(".volume");


      // Make sure waveformEl and data-src exist for the specific player
      if (!waveformEl || !waveformEl.dataset.src) {
        // console.error(`No data-src or waveform for player ${index + 1}`);
        return;
      }

      // Initialize WaveSurfer
      const wavesurfer = WaveSurfer.create({
        container: waveformEl,
        height: 40,
        waveColor: "#7C7E88",
        progressColor: player.classList.contains("two") ? "#fff" : "#000",
        cursorColor: "#000",
        barHeight: 0.7,
        barWidth: 1,
        barGap: 2,
        responsive: true,
      });

      wavesurfer.load(waveformEl.dataset.src);

      // Play/pause toggle
      playBtn.addEventListener("click", () => {
        wavesurfer.playPause();
        playBtn.classList.toggle("playing");
      });

      // 10s backward
      backBtn?.addEventListener("click", () => {
        wavesurfer.seekTo(
          Math.max((wavesurfer.getCurrentTime() - 10) / wavesurfer.getDuration(), 0)
        );
      });

      // 10s forward
      forwardBtn?.addEventListener("click", () => {
        wavesurfer.seekTo(
          Math.min((wavesurfer.getCurrentTime() + 10) / wavesurfer.getDuration(), 1)
        );
      });

      // Volume control
      volumeSlider?.addEventListener("input", (e) => {
        wavesurfer.setVolume(e.target.value);
      });

      // Time updates and debugging
      wavesurfer.on("ready", () => {
        console.log(`WaveSurfer Ready for Player ${index + 1}`);
        if (durationTimeEl) {
          durationTimeEl.textContent = formatTime(wavesurfer.getDuration());
        }
      });

      wavesurfer.on("audioprocess", () => {
        if (currentTimeEl) {
          currentTimeEl.textContent = formatTime(wavesurfer.getCurrentTime());
        }
      });

      function formatTime(sec) {
        const minutes = Math.floor(sec / 60);
        const seconds = Math.floor(sec % 60).toString().padStart(2, "0");
        return `${minutes}:${seconds}`;
      }
    });
  });


  $(document).ready(function () {
    $(".vibe-list li, .episode-time-box").each(function () {
      const audio = $(this).find(".podcast-audio")[0];
      const durationDisplay = $(this).find(".audio-duration");
      const playBtn = $(this).find(".pay-icon");

      // 🔁 Function to format time
      function formatTime(seconds) {
        const min = Math.floor(seconds / 60);
        const sec = Math.floor(seconds % 60).toString().padStart(2, "0");
        return `${min}:${sec}`;
      }

      // ✅ Fallback: If metadata already loaded
      if (audio.readyState >= 1) {
        durationDisplay.text(formatTime(audio.duration));
      } else {
        // 🔄 Wait for metadata to load
        audio.addEventListener("loadedmetadata", function () {
          durationDisplay.text(formatTime(audio.duration));
        });
      }

      // ▶️ Toggle play/pause
      playBtn.on("click", function () {
        $(".podcast-audio").each(function () {
          if (this !== audio) {
            this.pause();
            this.currentTime = 0;
            this._isPlaying = false;
          }
        });

        if (audio._isPlaying) {
          audio.pause();
          audio._isPlaying = false;
        } else {
          audio.play();
          audio._isPlaying = true;
        }
      });

      audio.addEventListener("ended", function () {
        audio._isPlaying = false;
      });
    });
  });







  if ($('.text-slider').length) {
    $('.text-slider').slick({
      speed: 5000,
      autoplay: true,
      autoplaySpeed: 0,
      cssEase: 'linear',
      slidesToShow: 4,
      slidesToScroll: 1,
      dots: false,
      arrows: false,
      variableWidth: true,
    })
  }


  if ($('.vibe-slider').length) {
    let $slider = $('.vibe-slider');
    let $progress = $('.custom-progress span');

    // Initialize slick
    $slider.slick({
      speed: 500,
      autoplay: true,
      autoplaySpeed: 2000,
      slidesToShow: 3,
      slidesToScroll: 1,
      dots: false,
      arrows: false,
      variableWidth: true,
      centerMode: true,
    });

    let totalSlides = $slider.find('.slick-slide').not('.slick-cloned').length;

    let progressBarContainer = $('.custom-progress');
    let containerWidth = progressBarContainer.width();
    let segmentWidth = containerWidth / totalSlides;

    $progress.css('width', `${segmentWidth}px`);

    $slider.on('init reInit afterChange', function (event, slick, currentSlide) {
      let index = currentSlide || 0;
      let translateX = segmentWidth * index;
      $progress.css('transform', `translateX(${translateX}px)`);
    });
  }

  if ($('.episodes-section').length) {
    let $slider = $('.episodes-slider');
    let $progress = $('.custom-progress-two span');

    // Initialize slick
    $slider.slick({
      speed: 500,
      autoplay: true,
      autoplaySpeed: 2000,
      slidesToShow: 3,
      slidesToScroll: 1,
      dots: false,
      arrows: false,
      variableWidth: true,
      centerMode: true,
    });

    let totalSlides = $slider.find('.slick-slide').not('.slick-cloned').length;

    let progressBarContainer = $('.custom-progress-two');
    let containerWidth = progressBarContainer.width();
    let segmentWidth = containerWidth / totalSlides;

    $progress.css('width', `${segmentWidth}px`);

    $slider.on('init reInit afterChange', function (event, slick, currentSlide) {
      let index = currentSlide || 0;
      let translateX = segmentWidth * index;
      $progress.css('transform', `translateX(${translateX}px)`);
    });
  }

  if ($('.banner-slider-two').length) {
    $('.banner-slider-two').slick({
      speed: 500,
      autoplay: true,
      autoplaySpeed: 3000,
      slidesToShow: 1,
      slidesToScroll: 1,
      dots: false,
      arrows: false,
      variableWidth: true,
      centerMode: true,
    })
  }


  $(document).ready(function () {
    const items = $(".vibe-item-two");
    const loadMoreBtn = $(".vibe-btn-two a");
    let visibleCount = 3;

    // Initial state: add 'show' class to first 3 items
    items.removeClass("show");
    items.slice(0, visibleCount).addClass("show");

    loadMoreBtn.on("click", function (e) {
      e.preventDefault();

      // Show next 1 item by adding 'show' class
      visibleCount++;
      items.slice(0, visibleCount).addClass("show");

      // Optional: hide button if all items are shown
      if (visibleCount >= items.length) {
        loadMoreBtn.hide();
      }
    });
  });


  if ($('.tag-slider').length) {
    $('.tag-slider').slick({
      speed: 5000,
      autoplay: true,
      autoplaySpeed: 0,
      cssEase: 'linear',
      slidesToShow: 5,
      slidesToScroll: 1,
      dots: false,
      arrows: false,
      variableWidth: true,
      centerMode: true,
    })
  }

  if ($('.testimonial-two').length) {
    $('.testimonial-slider-two').slick({
      speed: 500,
      autoplay: true,
      autoplaySpeed: 3000,
      slidesToShow: 1,
      slidesToScroll: 1,
      dots: false,
      arrows: true,
      appendArrows: $('.testimonial-two .custom-arrows'),
      prevArrow: '<button class="slick-prev"><img src="assets/images/btn-icon.svg" alt="Previous"></button>',
      nextArrow: '<button class="slick-next"><img src="assets/images/btn-icon.svg" alt="Next"></button>',
    });
  }

  if ($('.header-menu-collaps').length) {
    // mobail nav
    $(".header-menu-collaps").click(function () {
      $(".mobile-nav-wrapper").addClass("expanded");
    });
    $(".mobile-nav-toggler").click(function () {
      $(".mobile-nav-wrapper").removeClass("expanded");
    });
    $(".header-menu-collaps").click(function () {
      $("body").addClass("locked");
    });
    $(".mobile-nav-toggler").click(function () {
      $("body").removeClass("locked");
    });

  }
  if ($(".mobile-nav-container .mobile-menu-list").length) {
    // mobaile nav bar
    let dropdownAnchor = $(
      ".mobile-nav-container .mobile-menu-list .dropdown > a"
    );
    dropdownAnchor.each(function () {
      let self = $(this);
      let toggleBtn = document.createElement("BUTTON");
      toggleBtn.setAttribute("aria-label", "dropdown toggler");
      toggleBtn.innerHTML = "<i class='fa-solid fa-angle-right'></i>";
      self.append(function () {
        return toggleBtn;
      });
      self.find("button").on("click", function (e) {
        e.preventDefault();
        let self = $(this);
        self.toggleClass("expanded");
        self.parent().toggleClass("expanded");
        self.parent().parent().children("ul").slideToggle();
      });
    });
  }
  if ($(".preloader").length) {
    //Preloader
    $(window).on('load', function () {
      if ($('.preloader').length) {
        $('.preloader').delay(500).fadeOut(100);
      }
    });
  }
  $(window).on('scroll', function() {
    if ($(this).scrollTop() > 200) {
      $('.top-to-bottom').addClass('active');
    } else {
      $('.top-to-bottom').removeClass('active');
    }
  });





})
  (window.jQuery);
