<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Donations List</title>
    @include('user.headlink')
    <link rel="stylesheet" href="https://cdn.datatables.net/1.13.7/css/jquery.dataTables.min.css">
    <style>
        .badge-success { background-color: #28a745; }
        .badge-pending { background-color: #ffc107; color: #212529; }
        .badge-failed { background-color: #dc3545; }
        .action-btns { display: flex; gap: 8px; }
        .btn-view { background-color: #17a2b8; color: white; padding: 6px 12px; border: none; border-radius: 4px; }
        .btn-download { background-color: #28a745; color: white; padding: 6px 12px; border: none; border-radius: 4px; }
    </style>
</head>
<body>
    @include('admin.head_sidebar')
    <div class="content">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-12">
                    <div class="card shadow mb-4 animate__animated animate__fadeIn">
                        <div class="card-header py-3 d-flex justify-content-between align-items-center">
                            <h1 class="h3 mb-0 text-gray-800">All Donations</h1>
                        </div>
                        <div class="card-body">
                            <div class="table-responsive">
                                <table class="table table-bordered" id="donationsTable" width="100%" cellspacing="0">
                                    <thead>
                                        <tr>
                                            <th>#</th>
                                            <th>Transaction ID</th>
                                            <th>Donor Name</th>
                                            <th>Amount</th>
                                            <th>Payment Method</th>
                                            <th>Status</th>
                                            <th>Date</th>
                                            <th>Actions</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach ($donations as $index => $donation)
                                        <tr>
                                            <td>{{ $index + 1 }}</td>
                                            <td>{{ $donation->transaction_id }}</td>
                                            <td>{{ $donation->name }}</td>
                                            <td>₹{{ number_format($donation->amount, 2) }}</td>
                                            <td>{{ ucfirst($donation->payment_gateway) }}</td>
                                            <td>
                                                @if($donation->status == 'completed')
                                                    <span class="badge badge-success">Completed</span>
                                                @elseif($donation->status == 'pending')
                                                    <span class="badge badge-pending">Pending</span>
                                                @else
                                                    <span class="badge badge-failed">Failed</span>
                                                @endif
                                            </td>
                                            <td>{{ $donation->created_at->format('d-m-Y H:i') }}</td>
                                            <td class="action-btns">
                                                <a href="{{ route('admin.donations.show', $donation->id) }}" class="btn-view">
                                                    <i class="fas fa-eye"></i>
                                                </a>
                                                @if($donation->status == 'completed')
                                                <a href="{{ route('admin.donations.download', $donation->id) }}" class="btn-download">
                                                    <i class="fas fa-download"></i> 
                                                </a>
                                                @endif
                                            </td>
                                        </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
    <script src="https://cdn.datatables.net/1.13.7/js/jquery.dataTables.min.js"></script>
    <script>
        $(document).ready(function() {
            $('#donationsTable').DataTable({
                paging: true,
                searching: true,
                ordering: true,
                info: true,
                order: [[6, 'desc']] // Sort by date descending
            });
        });
    </script>
</body>
</html>
