<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Donation Invoice</title>
    <style>
        body { font-family: Arial, sans-serif; font-size: 12px; }
        .invoice-container { max-width: 100%; padding: 20px; }
        .header { text-align: center; margin-bottom: 20px; }
        .header h2 { margin-bottom: 5px; }
        .header p { margin-top: 0; }
        .invoice-info { display: flex; justify-content: space-between; margin-bottom: 20px; }
        .donor-info, .payment-info { width: 48%; }
        table { width: 100%; border-collapse: collapse; margin-bottom: 15px; }
        th, td { border: 1px solid #ddd; padding: 8px; text-align: left; }
        th { background-color: #f2f2f2; }
        .total { font-weight: bold; }
        .footer { margin-top: 30px; text-align: center; font-size: 0.9em; }
    </style>
</head>
<body>
    <div class="invoice-container">
        <div class="header">
            <h2>Donation Receipt</h2>
            <p>Thank you for your generous contribution</p>
        </div>

        <div class="invoice-info">
            <div class="donor-info">
                <h3>Donor Information</h3>
                <p><strong>Name:</strong> {{ $donation->name }}</p>
                <p><strong>Email:</strong> {{ $donation->email }}</p>
                <p><strong>Phone:</strong> {{ $donation->phone }}</p>
                <p><strong>Address:</strong> {{ $donation->address }}, {{ $donation->city }}, {{ $donation->state }} - {{ $donation->pincode }}</p>
            </div>

            <div class="payment-info">
                <h3>Payment Details</h3>
                <p><strong>Transaction ID:</strong> {{ $donation->transaction_id }}</p>
                <p><strong>Date:</strong> {{ $donation->created_at->format('d M Y, h:i A') }}</p>
                <p><strong>Payment Method:</strong> {{ ucfirst($donation->payment_gateway) }}</p>
                <p><strong>Status:</strong> {{ ucfirst($donation->status) }}</p>
            </div>
        </div>

        <h3>Donation Summary</h3>
        <table>
            <tr>
                <th>Description</th>
                <th>Amount</th>
            </tr>
            <tr>
                <td>Donation Contribution</td>
                <td>₹{{ number_format($donation->amount, 2) }}</td>
            </tr>
            <tr class="total">
                <td>Total Amount</td>
                <td>₹{{ number_format($donation->amount, 2) }}</td>
            </tr>
        </table>

        <div class="footer">
            <p>This is an official receipt for your donation. Thank you for your support!</p>
        </div>
    </div>
</body>
</html>
