<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Donation Details</title>
    @include('user.headlink')
    <style>
        .detail-card { border-left: 4px solid #4e73df; }
        .detail-label { font-weight: 600; color: #6c757d; }
    </style>
</head>
<body>
    @include('admin.head_sidebar')
    <div class="content">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-md-8">
                    <div class="card shadow mb-4 detail-card">
                        <div class="card-header py-3 d-flex justify-content-between align-items-center">
                            <h4 class="m-0 font-weight-bold text-primary">Donation Details</h4>
                            <a href="{{ route('admin.donations.index') }}" class="btn btn-secondary">
                                <i class="fas fa-arrow-left"></i> Back
                            </a>
                        </div>
                        <div class="card-body">
                            <div class="row mb-4">
                                <div class="col-md-6">
                                    <p class="detail-label">Transaction ID</p>
                                    <p>{{ $donation->transaction_id }}</p>
                                </div>
                                <div class="col-md-6">
                                    <p class="detail-label">Date</p>
                                    <p>{{ $donation->created_at->format('d M Y, h:i A') }}</p>
                                </div>
                            </div>

                            <div class="row mb-4">
                                <div class="col-md-6">
                                    <p class="detail-label">Donor Name</p>
                                    <p>{{ $donation->name }}</p>
                                </div>
                                <div class="col-md-6">
                                    <p class="detail-label">Email</p>
                                    <p>{{ $donation->email }}</p>
                                </div>
                            </div>

                            <div class="row mb-4">
                                <div class="col-md-6">
                                    <p class="detail-label">Amount</p>
                                    <p>₹{{ number_format($donation->amount, 2) }}</p>
                                </div>
                                <div class="col-md-6">
                                    <p class="detail-label">Status</p>
                                    <p>
                                        @if($donation->status == 'completed')
                                            <span class="badge badge-success">Completed</span>
                                        @elseif($donation->status == 'pending')
                                            <span class="badge badge-warning">Pending</span>
                                        @else
                                            <span class="badge badge-danger">Failed</span>
                                        @endif
                                    </p>
                                </div>
                            </div>

                            <div class="row mb-4">
                                <div class="col-md-6">
                                    <p class="detail-label">Payment Method</p>
                                    <p>{{ ucfirst($donation->payment_gateway) }}</p>
                                </div>
                                <div class="col-md-6">
                                    <p class="detail-label">Phone</p>
                                    <p>{{ $donation->phone }}</p>
                                </div>
                            </div>

                            <div class="row mb-4">
                                <div class="col-12">
                                    <p class="detail-label">Address</p>
                                    <p>
                                        {{ $donation->address }},<br>
                                        {{ $donation->city }}, {{ $donation->state }} - {{ $donation->pincode }},<br>
                                        {{ $donation->country }}
                                    </p>
                                </div>
                            </div>

                            @if($donation->status == 'completed')
                            <div class="text-center mt-4">
                                <a href="{{ route('admin.donations.download', $donation->id) }}" class="btn btn-primary">
                                    <i class="fas fa-download"></i> Download Invoice
                                </a>
                            </div>
                            @endif
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</body>
</html>
