<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Add New Video</title>
    @include('user.headlink')
    <style>
        .form-container {
            max-width: 800px;
            margin: 0 auto;
        }
        .form-group {
            margin-bottom: 1.5rem;
        }
        .form-label {
            display: block;
            margin-bottom: 0.5rem;
            font-weight: 500;
            color: #495057;
        }
        .form-control {
            width: 100%;
            padding: 0.75rem;
            border: 1px solid #ced4da;
            border-radius: 0.375rem;
            transition: border-color 0.15s ease-in-out;
            font-size: 1rem;
        }
        .form-control:focus {
            border-color: #86b7fe;
            outline: 0;
            box-shadow: 0 0 0 0.25rem rgba(13, 110, 253, 0.25);
        }
        select.form-control {
            appearance: none;
            background-image: url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 16 16'%3e%3cpath fill='none' stroke='%23343a40' stroke-linecap='round' stroke-linejoin='round' stroke-width='2' d='M2 5l6 6 6-6'/%3e%3c/svg%3e");
            background-repeat: no-repeat;
            background-position: right 0.75rem center;
            background-size: 16px 12px;
        }
        textarea.form-control {
            min-height: 120px;
            resize: vertical;
        }
        .btn-submit {
            background-color: #28a745;
            color: white;
            padding: 0.75rem 1.5rem;
            border: none;
            border-radius: 0.375rem;
            cursor: pointer;
            transition: background-color 0.15s ease-in-out;
            font-size: 1rem;
            display: inline-flex;
            align-items: center;
            gap: 8px;
        }
        .btn-submit:hover {
            background-color: #218838;
        }
        .action-btns {
            display: flex;
            gap: 15px;
            margin-top: 1.5rem;
        }
        .btn-secondary {
            background-color: #6c757d;
            color: white;
            padding: 0.75rem 1.5rem;
            border: none;
            border-radius: 0.375rem;
            cursor: pointer;
            text-decoration: none;
            display: inline-flex;
            align-items: center;
            justify-content: center;
            transition: background-color 0.15s ease-in-out;
        }
        .btn-secondary:hover {
            background-color: #5c636a;
        }
        .form-container {
    max-width: 900px;
        }
    </style>
</head>
<body>
    @include('admin.head_sidebar')
    <div class="content">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-md-12">
                    <div class="card shadow mb-4 animate__animated animate__fadeIn">
                        <div class="card-header py-3 d-flex justify-content-between align-items-center">
                            <h4 class="m-0 font-weight-bold text-primary">Add New Video</h4>
                            <a href="{{ route('admin.video') }}" class="btn btn-secondary">
                                <i class="fas fa-arrow-left"></i> &nbsp; Back to Videos
                            </a>
                        </div>
                        <div class="card-body">
                            <form method="POST" action="{{ route('videos.store') }}" class="form-container">
                                @csrf
 <div class="row justify-content-center">
                <div class="col-md-6">
                                <div class="form-group">
                                    <label for="category" class="form-label">Category</label>
                                    <select id="category" name="category" class="form-control" required>
                                        <option value="">Select Category</option>
                                        <option value="first" {{ old('category') == 'first' ? 'selected' : '' }}>First</option>
                                        <option value="second" {{ old('category') == 'second' ? 'selected' : '' }}>Second</option>
                                    </select>
                                    @error('category')
                                        <div class="text-danger mt-1">{{ $message }}</div>
                                    @enderror
                                </div>
                </div>
<div class="col-md-6">

                                <div class="form-group">
                                    <label for="hightlight" class="form-label">Highlight</label>
                                    <select id="hightlight" name="hightlight" class="form-control" required>
                                        <option value="0" {{ old('hightlight') == '0' ? 'selected' : '' }}>Normal</option>
                                        <option value="1" {{ old('hightlight') == '1' ? 'selected' : '' }}>High</option>
                                    </select>
                                    @error('hightlight')
                                        <div class="text-danger mt-1">{{ $message }}</div>
                                    @enderror
                                </div>
</div>

<div class="col-md-6">
                                <div class="form-group">
                                    <label for="heading" class="form-label">Heading</label>
                                    <input type="text" id="heading" name="heading" class="form-control" value="{{ old('heading') }}" required>
                                    @error('heading')
                                        <div class="text-danger mt-1">{{ $message }}</div>
                                    @enderror
                                </div>
</div>
<div class="col-md-6">

                                <div class="form-group">
                                    <label for="video_url" class="form-label">Video URL</label>
                                    <input type="url" id="video_url" name="video_url" class="form-control" value="{{ old('video_url') }}" required>
                                    @error('video_url')
                                        <div class="text-danger mt-1">{{ $message }}</div>
                                    @enderror
                                </div>
</div>
<div class="col-md-6">

                                <div class="form-group">
                                    <label for="date_time" class="form-label">Date Time</label>
                                    <input type="datetime-local" id="date_time" name="date_time" class="form-control" value="{{ old('date_time') }}">
                                    @error('date_time')
                                        <div class="text-danger mt-1">{{ $message }}</div>
                                    @enderror
                                </div>
</div>
<div class="col-md-6">

                                <div class="form-group">
                                    <label for="description" class="form-label">Description</label>
                                    <textarea id="description" name="description" class="form-control" rows="4">{{ old('description') }}</textarea>
                                    @error('description')
                                        <div class="text-danger mt-1">{{ $message }}</div>
                                    @enderror
                                </div>
</div>
<div class="col-md-6">
                                <div class="action-btns">
                                    <button type="submit" class="btn btn-submit">
                                        <i class="fas fa-save"></i> Save Video
                                    </button>
                                    <button type="reset" class="btn btn-secondary">
                                        <i class="fas fa-undo"></i> Reset
                                    </button>
                                </div>
</div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://kit.fontawesome.com/a076d05399.js" crossorigin="anonymous"></script>
</body>
</html>
