<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Edit Video</title>
    @include('user.headlink')
    <style>
        .form-container {
            max-width: 800px;
            margin: 0 auto;
        }
        .form-group {
            margin-bottom: 1.5rem;
        }
        .form-label {
            display: block;
            margin-bottom: 0.5rem;
            font-weight: 500;
            color: #495057;
        }
        .form-control {
            width: 100%;
            padding: 0.75rem;
            border: 1px solid #ced4da;
            border-radius: 0.375rem;
            transition: border-color 0.15s ease-in-out;
            font-size: 1rem;
        }
        .form-control:focus {
            border-color: #86b7fe;
            outline: 0;
            box-shadow: 0 0 0 0.25rem rgba(13, 110, 253, 0.25);
        }
        select.form-control {
            appearance: none;
            background-image: url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 16 16'%3e%3cpath fill='none' stroke='%23343a40' stroke-linecap='round' stroke-linejoin='round' stroke-width='2' d='M2 5l6 6 6-6'/%3e%3c/svg%3e");
            background-repeat: no-repeat;
            background-position: right 0.75rem center;
            background-size: 16px 12px;
        }
        textarea.form-control {
            min-height: 120px;
            resize: vertical;
        }
        .btn-update {
            background-color: #ffc107;
            color: #212529;
            padding: 0.75rem 1.5rem;
            border: none;
            border-radius: 0.375rem;
            cursor: pointer;
            transition: background-color 0.15s ease-in-out;
            font-size: 1rem;
            display: inline-flex;
            align-items: center;
            gap: 8px;
        }
        .btn-update:hover {
            background-color: #e0a800;
        }
        .action-btns {
            display: flex;
            gap: 15px;
            margin-top: 1.5rem;
        }
        .btn-secondary {
            background-color: #6c757d;
            color: white;
            padding: 0.75rem 1.5rem;
            border: none;
            border-radius: 0.375rem;
            cursor: pointer;
            text-decoration: none;
            display: inline-flex;
            align-items: center;
            justify-content: center;
            transition: background-color 0.15s ease-in-out;
        }
        .btn-secondary:hover {
            background-color: #5c636a;
        }
        .badge-high {
            background-color: #ffc107;
            color: #212529;
        }
        .badge-normal {
            background-color: #6c757d;
            color: white;
        }
    </style>
</head>
<body>
    @include('admin.head_sidebar')
    <div class="content">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-md-12">
                    <div class="card shadow mb-4 animate__animated animate__fadeIn">
                        <div class="card-header py-3 d-flex justify-content-between align-items-center">
                            <h4 class="m-0 font-weight-bold text-primary">Edit Video</h4>
                            <a href="{{ route('admin.video') }}" class="btn btn-secondary">
                                <i class="fas fa-arrow-left"></i> &nbsp; Back to Videos
                            </a>
                        </div>
                        <div class="card-body">
                            <form method="POST" action="{{ route('videos.update', $video->id) }}" class="form-container">
                                @csrf
                                @method('PUT')
<div class="row justify-content-center">
                <div class="col-md-6">
                                <div class="form-group">
                                    <label for="category" class="form-label">Category</label>
                                    <select id="category" name="category" class="form-control" required>
                                        <option value="first" {{ $video->category == 'first' ? 'selected' : '' }}>First</option>
                                        <option value="second" {{ $video->category == 'second' ? 'selected' : '' }}>Second</option>
                                    </select>
                                    @error('category')
                                        <div class="text-danger mt-1">{{ $message }}</div>
                                    @enderror
                                </div>
                </div>
   <div class="col-md-6">
                                <div class="form-group">
                                    <label for="highlight" class="form-label">Highlight Level</label>
                                    <select id="highlight" name="highlight" class="form-control" required>
                                        <option value="0" {{ $video->highlight == 0 ? 'selected' : '' }}>
                                            Normal
                                        </option>
                                        <option value="1" {{ $video->highlight == 1 ? 'selected' : '' }}>
                                            High
                                        </option>
                                    </select>
                                    @error('highlight')
                                        <div class="text-danger mt-1">{{ $message }}</div>
                                    @enderror
                                </div>
   </div>
   <div class="col-md-6">
                                <div class="form-group">
                                    <label for="heading" class="form-label">Heading</label>
                                    <input type="text" id="heading" name="heading" class="form-control"
                                           value="{{ old('heading', $video->heading) }}" required>
                                    @error('heading')
                                        <div class="text-danger mt-1">{{ $message }}</div>
                                    @enderror
                                </div>
   </div>

      <div class="col-md-6">
                                <div class="form-group">
                                    <label for="video_url" class="form-label">Video URL</label>
                                    <input type="url" id="video_url" name="video_url" class="form-control"
                                           value="{{ old('video_url', $video->video_url) }}" required>
                                    @error('video_url')
                                        <div class="text-danger mt-1">{{ $message }}</div>
                                    @enderror
                                </div>
      </div>

         <div class="col-md-6">
                                <div class="form-group">
                                    <label for="date_time" class="form-label">Date Time</label>
                                    <input type="datetime-local" id="date_time" name="date_time" class="form-control"
                                           value="{{ old('date_time', \Carbon\Carbon::parse($video->date_time)->format('Y-m-d\TH:i')) }}" required>
                                    @error('date_time')
                                        <div class="text-danger mt-1">{{ $message }}</div>
                                    @enderror
                                </div>
         </div>
   <div class="col-md-6">
                                <div class="form-group">
                                    <label for="description" class="form-label">Description</label>
                                    <textarea id="description" name="description" class="form-control" rows="4">
                                        {{ old('description', $video->description) }}
                                    </textarea>
                                    @error('description')
                                        <div class="text-danger mt-1">{{ $message }}</div>
                                    @enderror
                                </div>
   </div>
   <div class="col-md-6">
                                <div class="action-btns">
                                    <button type="submit" class="btn btn-update">
                                        <i class="fas fa-save"></i> Update Video
                                    </button>
                                    <a href="{{ route('admin.video') }}" class="btn btn-secondary">
                                        <i class="fas fa-times"></i> &nbsp; Cancel
                                    </a>
                                </div>
   </div>
</div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://kit.fontawesome.com/a076d05399.js" crossorigin="anonymous"></script>
</body>
</html>
