<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>Complete Your Donation</title>
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        .card {
            margin-top: 2rem;
            box-shadow: 0 4px 8px rgba(0,0,0,0.1);
        }
        .btn-primary {
            background-color: #3399cc;
            border-color: #3399cc;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-md-8">
                <div class="card">
                    <div class="card-header bg-primary text-white">Complete Your Donation</div>

                    <div class="card-body">
                        <form action="{{ route('razorpay.callback') }}" method="POST" id="razorpayForm">
                            @csrf
                            <input type="hidden" name="razorpay_payment_id" id="razorpay_payment_id">
                            <input type="hidden" name="razorpay_order_id" value="{{ $order_id }}">
                            <input type="hidden" name="razorpay_signature" id="razorpay_signature">
                            <input type="hidden" name="amount" value="{{ $amount }}">
                            <input type="hidden" name="create_account" value="{{ request('create_account', 0) }}">

                            <!-- Hidden user details -->
                            <input type="hidden" name="name" id="hidden_name" value="{{ $name }}">
                            <input type="hidden" name="email" id="hidden_email" value="{{ $email }}">
                            <input type="hidden" name="phone" id="hidden_phone" value="{{ $contact }}">

                            <div class="form-group mb-3">
                                <label for="name" class="form-label">Full Name</label>
                                <input type="text" class="form-control" id="name" name="visible_name" value="{{ $name }}" required readonly>
                            </div>

                            <div class="form-group mb-3">
                                <label for="email" class="form-label">Email</label>
                                <input type="email" class="form-control" id="email" name="visible_email" value="{{ $email }}" required readonly>
                            </div>

                            <div class="form-group mb-3">
                                <label for="phone" class="form-label">Phone Number</label>
                                <input type="tel" class="form-control" id="phone" name="visible_phone" value="{{ $contact }}" required readonly>
                            </div>

                            <div class="form-group mb-3">
                                <label for="address" class="form-label">Address</label>
                                <textarea class="form-control" id="address" name="visible_address" rows="3" required></textarea>
                                <input type="hidden" name="address" id="hidden_address">
                            </div>

                            <div class="row mb-3">
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label for="state" class="form-label">State</label>
                                        <select class="form-control" id="state" name="visible_state" required>
                                            <option value="">Select State</option>
                                            @foreach(['Maharashtra', 'Delhi', 'Karnataka', 'Tamil Nadu', 'Uttar Pradesh'] as $state)
                                                <option value="{{ $state }}">{{ $state }}</option>
                                            @endforeach
                                        </select>
                                        <input type="hidden" name="state" id="hidden_state">
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label for="city" class="form-label">City</label>
                                        <input type="text" class="form-control" id="city" name="visible_city" required>
                                        <input type="hidden" name="city" id="hidden_city">
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label for="pincode" class="form-label">PIN Code</label>
                                        <input type="text" class="form-control" id="pincode" name="visible_pincode" required>
                                        <input type="hidden" name="pincode" id="hidden_pincode">
                                    </div>
                                </div>
                            </div>

                            <div class="d-grid gap-2">
                                <button type="button" id="rzp-button" class="btn btn-primary btn-lg">
                                    Pay ₹{{ number_format($amount / 100, 2) }}
                                </button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Razorpay Checkout Script -->
    <script src="https://checkout.razorpay.com/v1/checkout.js"></script>
    <!-- Bootstrap JS Bundle with Popper -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // Update hidden fields when visible fields change
            const fields = ['address', 'state', 'city', 'pincode'];
            fields.forEach(field => {
                const visibleField = document.getElementById(field);
                const hiddenField = document.getElementById('hidden_' + field);
                if (visibleField && hiddenField) {
                    visibleField.addEventListener('change', function() {
                        hiddenField.value = this.value;
                    });

                    // For select elements, we need to handle differently
                    if (visibleField.tagName === 'SELECT') {
                        visibleField.addEventListener('change', function() {
                            hiddenField.value = this.options[this.selectedIndex].value;
                        });
                    }
                }
            });

            // Razorpay Checkout Handler
            var options = {
                "key": "{{ env('RAZORPAY_KEY') }}",
                "amount": "{{ $amount }}",
                "currency": "INR",
                "name": "Your Organization Name",
                "description": "Donation Payment",
                "image": "{{ asset('images/logo.png') }}", // Your logo URL
                "order_id": "{{ $order_id }}",
                "handler": function (response) {
                    document.getElementById('razorpay_payment_id').value = response.razorpay_payment_id;
                    document.getElementById('razorpay_signature').value = response.razorpay_signature;

                    // Validate all required fields are filled
                    const requiredFields = ['address', 'state', 'city', 'pincode'];
                    let isValid = true;

                    requiredFields.forEach(field => {
                        const value = document.getElementById(field).value;
                        if (!value) {
                            isValid = false;
                            alert(`Please fill in your ${field}`);
                        }
                    });

                    if (isValid) {
                        document.getElementById('razorpayForm').submit();
                    }
                },
                "prefill": {
                    "name": "{{ $name }}",
                    "email": "{{ $email }}",
                    "contact": "{{ $contact }}"
                },
                "notes": {
                    "donation": "Charitable contribution"
                },
                "theme": {
                    "color": "#3399cc"
                }
            };

            var rzp1 = new Razorpay(options);

            document.getElementById('rzp-button').onclick = function(e) {
                e.preventDefault();
                rzp1.open();
            }
        });
    </script>
</body>
</html>
