@extends('layouts.app')

@section('title', 'Donation Receipt')

@section('content')
<div class="row justify-content-center">
    <div class="col-lg-8">
        <div class="card shadow mb-4">
            <div class="card-header py-3 text-center">
                <h4 class="m-0 font-weight-bold text-primary">Donation Receipt</h4>
                <p class="mb-0">Thank you for your generous donation</p>
            </div>
            <div class="card-body">
                <div class="row mb-4">
                    <div class="col-md-6">
                        <div class="text-center mb-4">
                            <img src="https://via.placeholder.com/150x50?text=Organization+Logo" alt="Logo" class="mb-2">
                            <p class="mb-0">123 Charity Street</p>
                            <p class="mb-0">New York, NY 10001</p>
                            <p class="mb-0">Tax ID: 12-3456789</p>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="border p-3">
                            <h5 class="text-center mb-3">Receipt #{{ $donation->transaction_id }}</h5>
                            <table class="table table-sm table-borderless mb-0">
                                <tr>
                                    <th>Date:</th>
                                    <td>{{ $donation->created_at->format('F j, Y') }}</td>
                                </tr>
                                <tr>
                                    <th>Amount:</th>
                                    <td>${{ number_format($donation->amount, 2) }}</td>
                                </tr>
                                <tr>
                                    <th>Payment Method:</th>
                                    <td>{{ ucfirst(str_replace('_', ' ', $donation->payment_gateway)) }}</td>
                                </tr>
                            </table>
                        </div>
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-6">
                        <h5>Donor Information</h5>
                        <table class="table table-sm table-borderless">
                            <tr>
                                <th>Name:</th>
                                <td>{{ $donation->name }}</td>
                            </tr>
                            <tr>
                                <th>Email:</th>
                                <td>{{ $donation->email }}</td>
                            </tr>
                            <tr>
                                <th>Address:</th>
                                <td>{{ $donation->address }}</td>
                            </tr>
                            <tr>
                                <th>City/State/Zip:</th>
                                <td>{{ $donation->city }}, {{ $donation->state }} {{ $donation->pincode }}</td>
                            </tr>
                            <tr>
                                <th>Country:</th>
                                <td>{{ $donation->country }}</td>
                            </tr>
                        </table>
                    </div>
                    <div class="col-md-6">
                        <h5>Donation Details</h5>
                        <p>This is to certify that {{ $donation->name }} has made a donation of ${{ number_format($donation->amount, 2) }} to our organization on {{ $donation->created_at->format('F j, Y') }}.</p>
                        <p>No goods or services were provided in exchange for this contribution.</p>
                        <p>This receipt may be used for tax deduction purposes as allowed by law.</p>
                    </div>
                </div>

                <div class="mt-5 pt-4 border-top text-center">
                    <p class="mb-1">Thank you for your support!</p>
                    <p class="mb-0">For any questions, please contact donations@example.com</p>
                </div>

               <div class="d-flex justify-content-center mt-4">
    <button class="btn btn-primary me-2" onclick="window.print()">
        <i class="fas fa-print"></i> Print Receipt
    </button>
    <a href="{{ route('donations.receipt', ['donation' => $donation, 'download' => true]) }}" class="btn btn-success me-2">
        <i class="fas fa-download"></i> Download PDF
    </a>
    <a href="{{ route('donations.history') }}" class="btn btn-secondary">
        <i class="fas fa-arrow-left"></i> Back to History
    </a>
</div>
            </div>
        </div>
    </div>
</div>

<style>
    @media print {
        body * {
            visibility: hidden;
        }
        #main-layout, #main-layout * {
            visibility: visible;
        }
        #main-layout {
            position: absolute;
            left: 0;
            top: 0;
            width: 100%;
        }
        .sidebar, .navbar, .d-print-none {
            display: none !important;
        }
        .card {
            border: none !important;
            box-shadow: none !important;
        }
    }
</style>
@endsection
