@extends('layouts.app')

@section('title', 'Donation Details')

@section('content')
<div class="row justify-content-center">
    <div class="col-lg-8">
        <div class="card shadow mb-4 donation-card {{ $donation->status === 'success' ? 'success' : ($donation->status === 'failed' ? 'failed' : '') }}">
            <div class="card-header py-3 d-flex justify-content-between align-items-center">
                <h6 class="m-0 font-weight-bold text-primary">Donation Details</h6>
                @if($donation->status === 'success')
                    <a href="{{ route('donations.receipt', $donation) }}" class="btn btn-sm btn-outline-secondary">
                        <i class="fas fa-file-invoice"></i> Download Receipt
                    </a>
                @endif
            </div>
            <div class="card-body">
                <div class="row mb-4">
                    <div class="col-md-6">
                        <h5>Donation Information</h5>
                        <table class="table table-sm table-borderless">
                            <tr>
                                <th>Transaction ID:</th>
                                <td>{{ $donation->transaction_id ?? 'N/A' }}</td>
                            </tr>
                            <tr>
                                <th>Date:</th>
                                <td>{{ $donation->created_at->format('F j, Y, g:i a') }}</td>
                            </tr>
                            <tr>
                                <th>Amount:</th>
                                <td>${{ number_format($donation->amount, 2) }}</td>
                            </tr>
                            <tr>
                                <th>Payment Method:</th>
                                <td>{{ ucfirst(str_replace('_', ' ', $donation->payment_gateway)) }}</td>
                            </tr>
                            <tr>
                                <th>Status:</th>
                                <td>
                                    @if($donation->status === 'completed')
                                        <span class="badge bg-success">Success</span>
                                    @elseif($donation->status === 'pending')
                                        <span class="badge bg-warning">Pending</span>
                                    @else
                                        <span class="badge bg-danger">Failed</span>
                                    @endif
                                </td>
                            </tr>
                        </table>
                    </div>
                    <div class="col-md-6">
                        <h5>Donor Information</h5>
                        <table class="table table-sm table-borderless">
                            <tr>
                                <th>Name:</th>
                                <td>{{ $donation->name }}</td>
                            </tr>
                            <tr>
                                <th>Email:</th>
                                <td>{{ $donation->email }}</td>
                            </tr>
                            <tr>
                                <th>Phone:</th>
                                <td>{{ $donation->phone }}</td>
                            </tr>
                            <tr>
                                <th>Address:</th>
                                <td>{{ $donation->address }}</td>
                            </tr>
                            <tr>
                                <th>City/State/Zip:</th>
                                <td>{{ $donation->city }}, {{ $donation->state }} {{ $donation->pincode }}</td>
                            </tr>
                            <tr>
                                <th>Country:</th>
                                <td>{{ $donation->country }}</td>
                            </tr>
                        </table>
                    </div>
                </div>

                @if($donation->status === 'pending')
                <div class="alert alert-warning">
                    <i class="fas fa-info-circle"></i> Your donation is currently being processed. Please check back later for updates.
                </div>
                @elseif($donation->status === 'failed')
                <div class="alert alert-danger">
                    <i class="fas fa-exclamation-triangle"></i> Your donation was not successful. Please try again or contact support if you believe this is an error.
                </div>
                @endif

                <div class="d-flex justify-content-between mt-4">
                    <a href="{{ route('donations.history') }}" class="btn btn-secondary">
                        <i class="fas fa-arrow-left"></i> Back to History
                    </a>
                    @if($donation->status === 'failed' || $donation->status === 'pending')
                        <a href="{{ route('donations.create') }}" class="btn btn-primary">
                            <i class="fas fa-redo"></i> Try Again
                        </a>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
