<!DOCTYPE html>
<html>
<head>
    <title>New Contact Form Submission</title>
    <style>
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            line-height: 1.6;
            color: #333;
            max-width: 600px;
            margin: 0 auto;
            padding: 20px;
            background-color: #f9f9f9;
        }
        .email-container {
            background-color: #ffffff;
            border-radius: 8px;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1);
            padding: 30px;
        }
        .header {
            color: #2c3e50;
            border-bottom: 2px solid #3498db;
            padding-bottom: 10px;
            margin-bottom: 20px;
        }
        .field-label {
            font-weight: 600;
            color: #2c3e50;
            display: inline-block;
            width: 80px;
        }
        .message-content {
            background-color: #f5f5f5;
            padding: 15px;
            border-left: 4px solid #3498db;
            margin-top: 10px;
            border-radius: 0 4px 4px 0;
        }
        .footer {
            margin-top: 30px;
            font-size: 12px;
            color: #7f8c8d;
            text-align: center;
            border-top: 1px solid #eee;
            padding-top: 15px;
        }
    </style>
</head>
<body>
    <div class="email-container">
        <h1 class="header">New Contact Message</h1>

        <p><span class="field-label">Name:</span> {{ $details['name'] }}</p>
        <p><span class="field-label">Phone:</span> {{ $details['phone'] }}</p>
        <p><span class="field-label">Email:</span> {{ $details['email'] }}</p>

        <p class="field-label">Message:</p>
        <div class="message-content">
            {{ $details['message'] }}
        </div>

        <div class="footer">
            <p>This message was sent from your website's contact form.</p>
            <p>© {{ date('Y') }} Your Jertab Humanity. All rights reserved.</p>
        </div>
    </div>
</body>
</html>
