<!DOCTYPE html>
<html>
<head>
    <title>Thank You for Your Donation</title>
    <style>
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background-color: #f8fafc;
            margin: 0;
            padding: 0;
            color: #1a202c;
            line-height: 1.6;
        }
        .container {
            max-width: 800px;
            margin: 0 auto;
            padding: 20px;
        }
        .card {
            background: white;
            border-radius: 12px;
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.05);
            overflow: hidden;
            margin: 20px 0;
        }
        .header {
            background: linear-gradient(135deg, #4f46e5, #7c3aed);
            color: white;
            padding: 30px;
            text-align: center;
        }
        .logo {
            height: 60px;
            margin-bottom: 15px;
        }
        .content {
            padding: 30px;
        }
        .divider {
            height: 1px;
            background: #e2e8f0;
            margin: 25px 0;
        }
        .info-card {
            background: #f7fafc;
            border-radius: 8px;
            padding: 20px;
            margin-bottom: 25px;
        }
        .info-row {
            display: flex;
            margin-bottom: 12px;
        }
        .info-label {
            font-weight: 600;
            color: #4a5568;
            width: 150px;
        }
        .info-value {
            color: #1a202c;
            flex: 1;
        }
        .highlight {
            color: #4f46e5;
            font-weight: 700;
        }
        .btn {
            display: inline-block;
            padding: 12px 24px;
            border-radius: 6px;
            text-decoration: none;
            font-weight: 600;
            transition: all 0.2s;
            margin: 5px;
        }
        .btn-primary {
            background: #4f46e5;
            color: white;
        }
        .btn-primary:hover {
            background: #4338ca;
            transform: translateY(-2px);
            box-shadow: 0 4px 8px rgba(79, 70, 229, 0.2);
        }
        .btn-secondary {
            background: white;
            color: #4f46e5;
            border: 1px solid #4f46e5;
        }
        .btn-secondary:hover {
            background: #f5f3ff;
        }
        .footer {
            text-align: center;
            color: #718096;
            font-size: 14px;
            margin-top: 30px;
        }
        .signature {
            font-style: italic;
            color: #4a5568;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="card">
            <div class="header">
                <img src="{{ public_path('images/logo-white.png') }}" alt="Logo" class="logo">
                <h1>Thank You for Your Generosity</h1>
                <p>Your donation makes a real difference</p>
            </div>

            <div class="content">
                <p>Dear <strong>{{ $donation->name }}</strong>,</p>

                <p>We are truly grateful for your generous donation of
                <span class="highlight">₹{{ number_format($donation->amount, 2) }}</span>.
                Your support helps us continue our mission to make the world a better place.</p>

                <div class="divider"></div>

                <div class="info-card">
                    <h3>Donation Details</h3>
                    <div class="info-row">
                        <div class="info-label">Transaction ID</div>
                        <div class="info-value">{{ $donation->transaction_id }}</div>
                    </div>
                    <div class="info-row">
                        <div class="info-label">Date</div>
                        <div class="info-value">{{ $donation->created_at->format('F j, Y \a\t g:i A') }}</div>
                    </div>
                    <div class="info-row">
                        <div class="info-label">Payment Method</div>
                        <div class="info-value">{{ ucfirst($donation->payment_gateway) }}</div>
                    </div>
                    <div class="info-row">
                        <div class="info-label">Status</div>
                        <div class="info-value" style="color: #38a169;">Completed</div>
                    </div>
                </div>

                <div class="info-card">
                    <h3>Billing Information</h3>
                    <div class="info-value">
                        <strong>{{ $donation->name }}</strong><br>
                        {{ $donation->address }}<br>
                        {{ $donation->city }}, {{ $donation->state }} - {{ $donation->pincode }}<br>
                        India<br><br>
                        <strong>Email:</strong> {{ $donation->email ?? 'Not provided' }}<br>
                        <strong>Phone:</strong> {{ $donation->phone ?? 'Not provided' }}
                    </div>
                </div>

                <div style="text-align: center; margin-top: 30px;">
                   <form action="{{ route('donation.invoice.pdf') }}" method="POST" style="display: inline-block;">
    @csrf
    <input type="hidden" name="donation_id" value="{{ $donation->id }}">
    <button type="submit" class="btn btn-primary">Download Tax Receipt</button>
</form>
                    <a href="{{ url('/') }}" class="btn btn-secondary">Visit Our Website</a>
                </div>
            </div>
        </div>

        <div class="footer">
            <p class="signature">With sincere gratitude,</p>
            <p><strong>{{ config('app.name') }}</strong></p>
            <p>Have questions? Contact us at <a href="mailto:support@example.org" style="color: #4f46e5;">support@example.org</a></p>
        </div>
    </div>
</body>
</html>
