<!DOCTYPE html>
<html lang="{{ app()->getLocale() }}">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>{{ __('messages.title') }}</title>
    <link href="https://fonts.googleapis.com/css2?family=Noto+Sans+Tamil&display=swap" rel="stylesheet">
    <style>
        body {
            font-family: 'Arial', sans-serif;
            margin: 0;
            padding: 20px;
        }
        .tamil-text {
            font-family: 'Noto Sans Tamil', sans-serif;
        }
        .language-switcher {
            position: absolute;
            top: 10px;
            right: 10px;
        }
        select {
            padding: 5px;
            font-size: 16px;
        }
        .container {
            text-align: center;
        }
    </style>
</head>
<body>
    <div class="language-switcher">
        <select onchange="window.location.href=this.value">
            <option value="{{ route('language.switch', 'en') }}" {{ app()->getLocale() == 'en' ? 'selected' : '' }}>English</option>
            <option value="{{ route('language.switch', 'ta') }}" {{ app()->getLocale() == 'ta' ? 'selected' : '' }}>தமிழ்</option>
        </select>
    </div>

    <div class="container">
        <h1 class="tamil-text">{{ __('messages.welcome') }}</h1>
        <p>{{ __('messages.description') }}</p>
        <button>{{ __('messages.donate') }}</button>
    </div>
</body>
</html>
