<!DOCTYPE html>
<html lang="{{ app()->getLocale() }}">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>{{ __('messages.title') }}</title>
    <link href="https://fonts.googleapis.com/css2?family=Noto+Sans+Tamil&display=swap" rel="stylesheet">
    <style>
        body {
            font-family: 'Arial', sans-serif;
            margin: 0;
            padding: 20px;
            line-height: 1.6;
        }
        .tamil-text {
            font-family: 'Noto Sans Tamil', sans-serif;
        }
        .language-switcher {
            position: absolute;
            top: 10px;
            right: 10px;
        }
        select {
            padding: 5px;
            font-size: 16px;
        }
        .container {
            max-width: 800px;
            margin: 0 auto;
            text-align: center;
            padding: 20px;
        }
        .quote {
            font-style: italic;
            margin: 30px 0;
            font-size: 1.2em;
        }
        .highlight {
            font-weight: bold;
            margin: 20px 0;
        }
        .launch-info {
            background-color: #f8f9fa;
            padding: 20px;
            border-radius: 5px;
            margin: 30px 0;
        }
        .youtube-link {
            margin-top: 20px;
        }
    </style>
</head>
<body>
    <div class="language-switcher">
        <select onchange="window.location.href=this.value">
            <option value="{{ route('language.switch', 'en') }}" {{ app()->getLocale() == 'en' ? 'selected' : '' }}>English</option>
            <option value="{{ route('language.switch', 'ta') }}" {{ app()->getLocale() == 'ta' ? 'selected' : '' }}>தமிழ்</option>
        </select>
    </div>

    <div class="container">
        <h1>{{ __('messages.powerful_coming') }}</h1>
        <h2 class="tamil-text">{{ __('messages.jertab_humanity') }}</h2>

        <p class="quote">{{ __('messages.helmet_quote') }}</p>

        <div>
            <p>{{ __('messages.platform_description') }}</p>
            <p class="highlight">{{ __('messages.no_fame') }}</p>
        </div>

        <p>{{ __('messages.stay_tuned') }}</p>

        <div class="launch-info">
            <h3>🔔 {{ __('messages.launch_date') }}</h3>
            <p>{{ __('messages.first_experience') }}</p>
        </div>

        <div class="youtube-link">
            <p>💬 {{ __('messages.notify') }}</p>
            <p>👉 {{ __('messages.subscribe') }} <a href="https://www.youtube.com/@jertabhumanity" target="_blank">@JertabHumanity</a></p>
        </div>
    </div>
</body>
</html>
