<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Donation Invoice</title>
    <style>
        body { font-family: Arial, sans-serif; line-height: 1.6; color: #333333; }
        .logo { text-align: center; margin-bottom: 20px; }
        .header { background-color: #f8fafc; padding: 20px; border-radius: 8px; text-align: center; }
        .content { padding: 20px; background-color: #ffffff; border: 1px solid #e2e8f0; border-radius: 8px; margin-top: 20px; }
        table { width: 100%; font-size: 14px; margin-top: 10px; }
        td { padding: 8px 0; }
        .footer { text-align: center; margin-top: 20px; font-size: 12px; color: #6b7280; }
    </style>
</head>
<body>
    <div style="max-width: 600px; margin: 0 auto; padding: 20px;">
        <!-- Logo Section -->
        <div class="logo">
            @if(file_exists(public_path('home/logo2.png')))
                <img src="{{ public_path('home/logo2.png') }}" alt="1Logo" style="max-width: 150px; height: auto;">


            @else
                <!-- Fallback to URL if local file doesn't exist -->
                <img src="https://www.jertabhumanity.com/site/public/home/logo2.png" alt="Logo1" style="max-width: 150px; height: auto;">
                <img src="data:image/png;base64,{{ base64_encode(file_get_contents(public_path('home/logo2.png'))) }}" alt="Logo1" style="max-width: 150px; height: auto;">
            @endif
        </div>

        <!-- Header -->
        <div class="header">
            <h1 style="font-size: 24px; color: #264668; margin: 0;">Donation Invoice</h1>
        </div>

        <!-- Content -->
        <div class="content">
            <p style="font-size: 16px;">Dear {{ $donation->name }},</p>
            <p style="font-size: 16px;">Thank you for your generous donation of <strong>Rs {{ number_format($donation->amount, 2) }}</strong>.</p>

            <!-- Donation Details -->
            <h2 style="font-size: 18px; color: #264668; margin-top: 20px;">Donation Details</h2>
            <table>
                <tr>
                    <td style="color: #4b5563;">Transaction ID:</td>
                    <td>{{ $donation->transaction_id }}</td>
                </tr>
                <tr>
                    <td style="color: #4b5563;">Date:</td>
                    <td>{{ $donation->created_at->format('d M Y h:i A') }}</td>
                </tr>
                <tr>
                    <td style="color: #4b5563;">Payment Method:</td>
                    <td>{{ ucfirst($donation->payment_gateway) }}</td>
                </tr>
            </table>

            <!-- Billing Information -->
            <h2 style="font-size: 18px; color: #264668; margin-top: 20px;">Billing Information</h2>
            <p style="font-size: 14px; margin: 10px 0;">
                {{ $donation->name }}<br>
                {{ $donation->address }}<br>
                {{ $donation->city }}, {{ $donation->state }} - {{ $donation->pincode }}<br>
                India
            </p>
        </div>

        <!-- Footer -->
        <div class="footer">
            <p>With gratitude,<br>{{ config('app.name') }}</p>
            <p style="margin-top: 10px;">© {{ date('Y') }} {{ config('app.name') }}. All rights reserved.</p>
        </div>
    </div>
</body>
</html>
