<!DOCTYPE html>
<html>
<head>
    @include('googletag')
      <meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Jertab Humanity | Restoring Dignity & Hope Through Compassion</title>
<meta name="description" content="Jertab Humanity provides food, shelter, financial aid, and resources to those in need, helping rebuild lives and small businesses with kindness and dignity.">
<link rel="shortcut icon" href="{{asset('home/logo2.png')}}" type="image/x-icon">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
    /* Video Gallery Styles */
.video-container {
    margin-top: 190px !important;
}

.year-tabs-wrapper, .month-tabs-wrapper {
    position: relative;
}

.year-tabs-container, .month-filters-container {
    display: flex;
    overflow-x: auto;
    scroll-behavior: smooth;
    padding-bottom: 10px;
    white-space: nowrap;
    scrollbar-width: thin;
    scrollbar-color: #274768 #f0f0f0;
}

.year-tabs-container::-webkit-scrollbar,
.month-filters-container::-webkit-scrollbar {
    width: 3px;
    height: 3px;
}

.year-tabs-container::-webkit-scrollbar-track,
.month-filters-container::-webkit-scrollbar-track {
    background: #f0f0f0;
    border-radius: 3px;
}

.year-tabs-container::-webkit-scrollbar-thumb,
.month-filters-container::-webkit-scrollbar-thumb {
    background: #274768;
    border-radius: 3px;
}

.year-tab {
    display: inline-block;
    padding: 6px 30px;
    margin-right: 5px;
    border-radius: 30px;
    background: #f0f0f0;
    text-decoration: none;
    color: #333;
    flex-shrink: 0;
}

.year-tab.active {
    background: #274768;
    color: white;
}

.month-link {
    display: inline-block;
    padding: 6px 30px;
    margin-right: 5px;
    background: #f0f0f0;
    border-radius: 20px;
    text-decoration: none;
    color: #333;
    flex-shrink: 0;
}

.month-link.active {
    background: #274768;
    color: white;
}

.video-item {
    border: 1px solid #ddd;
    padding: 15px;
    border-radius: 10px;
    height: 100%;
    transition: all 0.3s ease;
}

.video-item.highlighted {
    border: 2px solid #ffc107;
    background-color: #fff8e1;
}

.highlight-badge {
    background: #ffc107;
    color: #333;
    padding: 4px 10px;
    border-radius: 5px;
    font-size: 0.8rem;
    margin-left: 8px;
}

.date-form label {
    margin-bottom: 0;
}

.nav-arrow {
    position: absolute;
    top: 50%;
    transform: translateY(-50%);
    background: white;
    border: 1px solid #ddd;
    border-radius: 50%;
    width: 35px;
    height: 35px;
    display: flex;
    align-items: center;
    justify-content: center;
    cursor: pointer;
    z-index: 1;
    box-shadow: 0 2px 4px rgba(0,0,0,0.1);
}

.nav-arrow:hover {
    background: #f8f9fa;
}

.nav-arrow.left {
    left: 0;
    margin-top: -8px;
}

.nav-arrow.right {
    right: 0;
    margin-top: -8px;
}

.year-tabs-wrapper, .month-tabs-wrapper {
    padding: 0 40px;
}

/* Video Grid Styles */
.blog-box1 {
    padding: 10px;
    border: 2px solid #c9c9c9;
    border-radius: 15px;
    transition: all 0.3s ease;
    cursor: pointer;
}

.blog-box1:hover {
    box-shadow: 0 4px 12px rgba(0,0,0,0.1);
}

.btnvideo {
    border: 2px dashed #000;
    border-radius: 20px;
    padding: 10px 20px;
    margin: 10px;
    transition: all 0.5s ease;
}

.blog-box1:hover .btnvideo {
    margin-left: 20px;
    border: 2px solid #c9c9c9;
}

.videoimg {
    height: 200px !important;
    object-fit: cover;
    width: 100%;
    border-radius: 10px;
}

/* Modal Styles */
.modal {
    display: none;
    position: fixed;
    z-index: 1000;
    left: 0;
    top: 0;
    width: 100%;
    height: 100%;
    background-color: rgba(0,0,0,0.9);
    overflow: auto;
}

.modal-content {
    position: relative;
    margin: 5% auto;
    padding: 20px;
    width: 90%;
    max-width: 800px;
}

.video-wrapper {
    position: relative;
    padding-bottom: 56.25%;
    height: 0;
}

.video-wrapper iframe {
    position: absolute;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
}

.close {
    position: absolute;
    right: 20px;
    top: 10px;
    color: white;
    font-size: 30px;
    font-weight: bold;
    cursor: pointer;
}

/* Loading spinner */
.loading-spinner {
    display: none;
    text-align: center;
    padding: 20px;
}

.loading-spinner i {
    font-size: 1.5rem;
    color: #274768;
}

/* Date Range Filter Styles */
.date-range-overlay {
    display: none;
    position: fixed;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    background-color: rgba(0, 0, 0, 0.5);
    z-index: 999;
}

.date-range-filter {
    display: block;
}

.date-range-filter form {
    display: flex;
    align-items: center;
    flex-wrap: wrap;
    gap: 10px;
}

.date-range-filter label {
    margin-bottom: 0;
}

.date-range-filter input {
    width: auto;
}

.search-icon {
    display: none !important;
    cursor: pointer;
    font-size: 1.5rem;
    color: #274768;
}

/* Custom button style */
.govido {
    background: #274768 !important;
    color: white !important;
    border: none;
    padding: 8px 20px;
    border-radius: 5px;
}

/* Responsive Adjustments */
@media (max-width: 767.98px) {
    .video-container {
        margin-top: 120px !important;
    }

    .year-tabs-container, .month-filters-container {
        padding-bottom: 15px;
    }

    .year-tab, .month-link {
        padding: 6px 15px;
        font-size: 0.85rem;
    }

    .nav-arrow {
        width: 30px;
        height: 30px;
    }

    .nav-arrow.left {
        left: 5px;
        margin-top: -8px;
    }

    .nav-arrow.right {
        right: 5px;
        margin-top: -8px;
    }

    .date-range-overlay.active,
    .date-range-filter.active {
        display: block;
    }

    .date-range-filter {
        display: none;
        position: fixed;
        left: 50%;
        top: 50%;
        transform: translate(-50%, -50%);
        background: white;
        padding: 20px;
        border-radius: 10px;
        box-shadow: 0 4px 12px rgba(0,0,0,0.15);
        z-index: 1000;
        width: calc(100% - 40px);
        max-width: 400px;
    }

    .date-range-filter form {
        flex-direction: column;
        gap: 15px;
    }

    .date-range-filter label {
        width: 100%;
        margin-bottom: 5px;
        font-weight: 500;
    }

    .date-range-filter input {
        width: 100% !important;
        padding: 8px 12px;
    }

    .search-icon {
        display: block !important;
        position: absolute;
        right: 15px;
        top: -40px;
    }

    .videoimg {
        height: 150px !important;
    }

    .modal-content {
        width: 95%;
        margin: 10% auto;
    }
}

@media (min-width: 768px) {
    .container {
        max-width: 1200px;
    }

    .year-tab, .month-link {
        padding: 6px 30px;
        font-size: 0.9rem;
    }

    .videoimg {
        height: 250px !important;
    }

    .date-range-overlay {
        display: none !important;
    }
}

@media (min-width: 992px) {
    .videoimg {
        height: 300px !important;
    }
}

/* Preloader Styles */
.preloader {
    background: #363838cd;
    position: fixed;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    z-index: 9999999999999;
    backdrop-filter: blur(10px);
    -webkit-backdrop-filter: blur(10px);
    display: flex;
    align-items: center;
    justify-content: center;
    transition: opacity 0.5s ease;
}

.loading-container {
    width: 100%;
    max-width: 620px;
    text-align: center;
    color: #fff;
    position: relative;
}

.loader {
    width: fit-content;
    font-size: 60px;
    font-family: system-ui, sans-serif;
    font-weight: bold;
    text-transform: uppercase;
    color: #0000;
    -webkit-text-stroke: 1px #000;
    background:
        conic-gradient(from -135deg at 100% 50%, #264668 90deg, #d0a933 0) text no-repeat,
        conic-gradient(from -135deg at 1lh  50%, #d0a933 90deg, #264668 0) text no-repeat;
    animation: l6 2s linear infinite;
}

.loader:before {
    content: "JERTAB HUMANITY";
}

@keyframes l6 {
    0%     {background-size: 0 200%; background-position:0 0, 100% 0}
    50%    {background-size: calc(60% + .5lh) 200%; background-position:0 0, 100% 0}
    50.01% {background-size: calc(60% + .5lh) 200%; background-position:0 100%, 100% 100%}
    100%   {background-size: 0 200%; background-position:0 100%, 100% 100%}
}

/* Responsive adjustments for preloader */
@media (max-width: 767.98px) {
    .loader {
        font-size: 40px;
    }
}

@media (max-width: 480px) {
    .loader {
        font-size: 30px;
    }
}
    </style>
    @include('header')
</head>
<body>
    @include('menu')
    <div class="container video-container">
        <!-- Filters Section -->
        <div class="video-filters mb-4">
            <!-- First row: Year tabs and Date range -->
            <div class="row mb-3 align-items-center">
                <div class="col-10 col-md-6 mb-3 mb-md-0">
                    <div class="year-tabs-wrapper position-relative">
                        <div class="nav-arrow left" onclick="scrollTabs('year', -100)">
                            <i class="fas fa-chevron-left"></i>
                        </div>
                        <div class="year-tabs-container scroll-wrapper" id="yearTabs">
                            @foreach ($years as $year)
                                <a href="{{ route('videos.index', ['year' => $year, 'month' => 'all']) }}"
                                   class="year-tab {{ $selectedYear == $year ? 'active' : '' }}"
                                   data-year="{{ $year }}">
                                    {{ $year }}
                                </a>
                            @endforeach
                        </div>
                        <div class="nav-arrow right" onclick="scrollTabs('year', 100)">
                            <i class="fas fa-chevron-right"></i>
                        </div>
                    </div>
                </div>
             <div class="col-2 col-md-6 mb-3 mb-md-0">
    <!-- Search icon (mobile only) -->
    <i class="fas fa-search search-icon" onclick="toggleDateRangeForm()"></i>

    <!-- Background overlay (mobile only) -->
    <div class="date-range-overlay" id="dateRangeOverlay"></div>

    <!-- Date range filter (normal on desktop, modal on mobile) -->
    <div class="date-range-filter" id="dateRangeFilter">
        <form id="dateRangeForm" class="d-flex align-items-center flex-wrap gap-2">
            <label>From Date:</label>
            <input type="date" name="from_date" value="{{ $fromDate }}" class="form-control form-control-sm">
            <label>To Date:</label>
            <input type="date" name="to_date" value="{{ $toDate }}" class="form-control form-control-sm">
            <button type="submit" class="btn btn-primary btn-sm govido">Go</button>
        </form>
    </div>
</div>
            </div>

            <!-- Second row: Month filters -->
            <div class="row">
                <div class="col-12">
                    <div class="month-tabs-wrapper position-relative">
                        <div class="nav-arrow left" onclick="scrollTabs('month', -100)">
                            <i class="fas fa-chevron-left"></i>
                        </div>
                        <div class="month-filters-container scroll-wrapper" id="monthTabs">
                            @foreach ($months as $key => $month)
                                <a href="{{ route('videos.index', ['year' => $selectedYear, 'month' => $key]) }}"
                                   class="month-link {{ $selectedMonth == $key ? 'active' : '' }}"
                                   data-month="{{ $key }}">
                                    {{ $month }}
                                </a>
                            @endforeach
                        </div>
                        <div class="nav-arrow right" onclick="scrollTabs('month', 100)">
                            <i class="fas fa-chevron-right"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Loading Spinner -->
        <div id="loadingSpinner" class="loading-spinner">
            <i class="fas fa-spinner fa-spin"></i>
            <p>Loading videos...</p>
        </div>

        <!-- Video List -->
        <div class="row row-cols-1 row-cols-md-2 row-cols-lg-3 g-4" id="videoListContainer">
            @include('users.videos.video_list', ['videos' => $videos])
        </div>
    </div>

    <!-- Video Modal -->
    <div id="videoModal" class="modal">
        <div class="modal-content">
            <span class="close" onclick="closeModal()">×</span>
            <div class="video-wrapper">
                <iframe id="youtubeFrame" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>

<div class="preloader" id="preloader">
        <div class="loading-container">
            <div class="loader"></div>
        </div>
    </div>
<script>
    document.addEventListener('DOMContentLoaded', function() {
    // Initialize active filters
    const urlParams = new URLSearchParams(window.location.search);
    const year = urlParams.get('year');
    const month = urlParams.get('month');
    const fromDate = urlParams.get('from_date');
    const toDate = urlParams.get('to_date');

    // Set active year tab
    if (year) {
        document.querySelectorAll('.year-tab').forEach(tab => tab.classList.remove('active'));
        const activeYearTab = document.querySelector(`.year-tab[data-year="${year}"]`);
        if (activeYearTab) activeYearTab.classList.add('active');
    }

    // Set active month tab
    if (month) {
        document.querySelectorAll('.month-link').forEach(tab => tab.classList.remove('active'));
        const activeMonthTab = document.querySelector(`.month-link[data-month="${month}"]`);
        if (activeMonthTab) activeMonthTab.classList.add('active');
    }

    // Set date inputs
    if (fromDate) document.querySelector('input[name="from_date"]').value = fromDate;
    if (toDate) document.querySelector('input[name="to_date"]').value = toDate;

    // Event listeners
    document.querySelectorAll('.year-tab').forEach(tab => {
        tab.addEventListener('click', handleYearTabClick);
    });

    document.querySelectorAll('.month-link').forEach(tab => {
        tab.addEventListener('click', handleMonthTabClick);
    });

    document.getElementById('dateRangeForm').addEventListener('submit', handleDateRangeSubmit);
    window.addEventListener('popstate', handlePopState);

    // Preloader
    setTimeout(() => {
        document.getElementById('preloader').style.opacity = '0';
        setTimeout(() => {
            document.getElementById('preloader').style.display = 'none';
        }, 500);
    }, 1000);
});

// Filter handling functions
function handleYearTabClick(e, year) {
    e.preventDefault();

    // Clear date range when selecting year
    document.querySelector('input[name="from_date"]').value = '';
    document.querySelector('input[name="to_date"]').value = '';
    document.getElementById('dateRangeFilter').classList.remove('date-range-active');

    // Set active year
    document.querySelectorAll('.year-tab').forEach(tab => tab.classList.remove('active', 'filter-active'));
    e.currentTarget.classList.add('active', 'filter-active');

    updateFilters();
}

function handleMonthTabClick(e, month) {
    e.preventDefault();

    // Clear date range when selecting month
    document.querySelector('input[name="from_date"]').value = '';
    document.querySelector('input[name="to_date"]').value = '';
    document.getElementById('dateRangeFilter').classList.remove('date-range-active');

    // Set active month
    document.querySelectorAll('.month-link').forEach(tab => tab.classList.remove('active', 'filter-active'));
    e.currentTarget.classList.add('active', 'filter-active');

    updateFilters();
}

function handleDateRangeSubmit(e) {
    e.preventDefault();
    updateFilters();
}
function clearDateRange() {
    document.querySelector('input[name="from_date"]').value = '';
    document.querySelector('input[name="to_date"]').value = '';
    document.getElementById('dateRangeFilter').classList.remove('date-range-active');
    updateFilters();
}
function handlePopState() {
    const urlParams = new URLSearchParams(window.location.search);
    const year = urlParams.get('year');
    const month = urlParams.get('month');
    const fromDate = urlParams.get('from_date');
    const toDate = urlParams.get('to_date');

    if (year) {
        document.querySelectorAll('.year-tab').forEach(tab => tab.classList.remove('active'));
        const yearTab = document.querySelector(`.year-tab[data-year="${year}"]`);
        if (yearTab) yearTab.classList.add('active');
    }

    if (month) {
        document.querySelectorAll('.month-link').forEach(tab => tab.classList.remove('active'));
        const monthTab = document.querySelector(`.month-link[data-month="${month}"]`);
        if (monthTab) monthTab.classList.add('active');
    }

    if (fromDate) document.querySelector('input[name="from_date"]').value = fromDate;
    if (toDate) document.querySelector('input[name="to_date"]').value = toDate;

    updateFilters();
}

function updateFilters() {
    const selectedYear = document.querySelector('.year-tab.active')?.dataset.year;
    const selectedMonth = document.querySelector('.month-link.active')?.dataset.month;
    const fromDate = document.querySelector('input[name="from_date"]').value;
    const toDate = document.querySelector('input[name="to_date"]').value;

    document.getElementById('loadingSpinner').style.display = 'block';

    const params = new URLSearchParams();

    // Always include date range if specified
    if (fromDate) params.append('from_date', fromDate);
    if (toDate) params.append('to_date', toDate);

    // Only include year/month if no date range is active
    if (!fromDate && !toDate) {
        if (selectedYear) params.append('year', selectedYear);
        if (selectedMonth) params.append('month', selectedMonth);
    }

    fetch(`{{ route('videos.index') }}?${params.toString()}&ajax=true`, {
        headers: {
            'X-Requested-With': 'XMLHttpRequest',
            'Accept': 'application/json'
        }
    })
    .then(response => response.json())
    .then(data => {
        document.getElementById('videoListContainer').innerHTML = data.html;
        updateURL(params);

        // Update UI to reflect active filters
        if (fromDate || toDate) {
            // Clear year/month active states when using date range
            document.querySelectorAll('.year-tab, .month-link').forEach(tab => {
                tab.classList.remove('active', 'filter-active');
            });
            document.getElementById('dateRangeFilter').classList.add('date-range-active');
        } else {
            document.getElementById('dateRangeFilter').classList.remove('date-range-active');
        }
    })
    .finally(() => {
        document.getElementById('loadingSpinner').style.display = 'none';
        if (window.innerWidth < 768) closeDateRangeFilter();
    });
}
function updateURL(year, month, fromDate, toDate) {
    const params = new URLSearchParams();
    if (year) params.append('year', year);
    if (month) params.append('month', month);
    if (fromDate) params.append('from_date', fromDate);
    if (toDate) params.append('to_date', toDate);

    const newUrl = `${window.location.pathname}?${params.toString()}`;
    window.history.pushState({ path: newUrl }, '', newUrl);
}

// Mobile date range functions
function toggleDateRangeForm() {
    if (window.innerWidth < 768) {
        const overlay = document.getElementById('dateRangeOverlay');
        const filter = document.getElementById('dateRangeFilter');

        overlay.classList.toggle('active');
        filter.classList.toggle('active');
        document.body.style.overflow = filter.classList.contains('active') ? 'hidden' : '';

        overlay.onclick = closeDateRangeFilter;
    }
}

function closeDateRangeFilter() {
    if (window.innerWidth < 768) {
        const overlay = document.getElementById('dateRangeOverlay');
        const filter = document.getElementById('dateRangeFilter');

        overlay.classList.remove('active');
        filter.classList.remove('active');
        document.body.style.overflow = '';
    }
}

// Video modal functions
function openVideoModal(videoId) {
    const modal = document.getElementById('videoModal');
    const iframe = document.getElementById('youtubeFrame');
    iframe.src = `https://www.youtube.com/embed/${videoId}?autoplay=1`;
    modal.style.display = "block";
    document.body.style.overflow = "hidden";
}

function closeModal() {
    const modal = document.getElementById('videoModal');
    const iframe = document.getElementById('youtubeFrame');
    iframe.src = '';
    modal.style.display = "none";
    document.body.style.overflow = "auto";
}

// Tab scrolling
function scrollTabs(type, amount) {
    const container = document.getElementById(`${type}Tabs`);
    container.scrollBy({ left: amount, behavior: 'smooth' });
}

// Window resize handler
window.addEventListener('resize', function() {
    if (window.innerWidth >= 768) {
        closeDateRangeFilter();
    }
});

// Click outside modal handler
window.onclick = function(event) {
    const modal = document.getElementById('videoModal');
    if (event.target == modal) closeModal();

    const preloader = document.getElementById('preloader');
    if (preloader.style.display !== 'none') {
        preloader.style.opacity = '0';
        setTimeout(() => preloader.style.display = 'none', 500);
    }
};

// Fallback preloader hide
setTimeout(() => {
    const preloader = document.getElementById('preloader');
    if (preloader.style.display !== 'none') {
        preloader.style.opacity = '0';
        setTimeout(() => preloader.style.display = 'none', 500);
    }
}, 5000);
</script>
</body>
</html>
