<?php
use App\Http\Controllers\AdminController;
use App\Http\Controllers\DonationController;
use App\Http\Controllers\VideoController;
use Illuminate\Support\Facades\Mail;
use App\Http\Controllers\AuthController;
use App\Http\Controllers\ContactController;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\HomeController;

Route::get('/public', function () {
    abort(404);
});

Route::get('/admin/login', [AdminController::class, 'adminshowLoginForm'])->name('adlogin');
Route::post('/admin/login', [AdminController::class, 'adminlogin'])->name('admin.login');

Route::middleware('auth')->prefix('admin')->group(function () {
    Route::get('/dashboard', [AdminController::class, 'dashboard'])->name('admin.dashboard');
    Route::get('/banners', [AdminController::class, 'index'])->name('admin.banner');
    Route::get('/banners/create', [AdminController::class, 'create'])->name('banners.create');
    Route::post('/banners/store', [AdminController::class, 'store'])->name('banners.store');
    Route::get('/banners/{banner}/edit', [AdminController::class, 'edit'])->name('banners.edit');
    Route::put('/banners/{banner}', [AdminController::class, 'update'])->name('banners.update');
    Route::delete('/banners/{banner}', [AdminController::class, 'destroy'])->name('banners.destroy');

    Route::get('/videos', [AdminController::class, 'indexVideos'])->name('admin.video');
    Route::get('/videos/create', [AdminController::class, 'createVideos'])->name('videos.create');
    Route::post('/videos/store', [AdminController::class, 'storeVideos'])->name('videos.store');
    Route::get('/videos/{video}/edit', [AdminController::class, 'editVideos'])->name('videos.edit');
    Route::put('/videos/{video}', [AdminController::class, 'updateVideos'])->name('videos.update');
    Route::delete('/videos/{video}', [AdminController::class, 'destroyVideos'])->name('videos.destroy');


      Route::get('/contacts', [ContactController::class, 'index'])->name('admin.contacts.index');
    Route::get('/contacts/{contact}', [ContactController::class, 'show'])->name('admin.contacts.show');
    Route::post('/contacts/{contact}/mark-as-read', [ContactController::class, 'markAsRead'])->name('admin.contacts.markAsRead');
    Route::delete('/contacts/{contact}', [ContactController::class, 'destroy'])->name('admin.contacts.destroy');


     Route::get('/donations', [DonationController::class, 'ddindex'])->name('admin.donations.index');
    Route::get('/donations/{donation}', [DonationController::class, 'ddshow'])->name('admin.donations.show');
    Route::get('/donations/{donation}/download', [DonationController::class, 'dddownloadInvoice'])->name('admin.donations.download');

});

// routes/web.php
Route::get('/donate', [DonationController::class, 'showDonationForm'])->name('donate');
Route::post('/donate/process', [DonationController::class, 'processDonation'])->name('donate.process');
// In routes/web.php
Route::get('/donate/complete', [DonationController::class, 'completeDonation'])->name('donate.complete');
Route::post('/payment/razorpay/callback', [DonationController::class, 'handleRazorpayCallback'])->name('razorpay.callback');
Route::post('/payment/stripe/webhook', [DonationController::class, 'handleStripeWebhook']);
// routes/web.php
Route::get('/donation/success', [DonationController::class, 'showSuccess'])->name('donate.success');



Route::get('/donations/invoice/token/{token}', [DonationController::class, 'downloadInvoiceByToken'])->name('donations.invoice.token');
Route::get('/download-invoice/{token}', [DonationController::class, 'downloadInvoiceByTokenuser'])->name('download.invoice');
Route::get('/test-email', function() {
    try {
        Mail::raw('This is a test email from the system', function($message) {
            $message->to('rckedi1013@gmail.com')
                    ->subject('System Test Email');
        });

        return response()->json(['status' => 'success', 'message' => 'Test email sent successfully']);
    } catch (\Exception $e) {
        return response()->json(['status' => 'error', 'message' => $e->getMessage()], 500);
    }
})->name('test.email');


Route::get('/videos', [VideoController::class, 'index'])->name('videos.index');
Route::get('/about', [VideoController::class, 'about'])->name('about');
Route::get('/', [VideoController::class, 'homepage'])->name('home.index');
Route::get('contact',[VideoController::class,'contact'])->name('contact');
Route::post('savecontact',[VideoController::class,'contactsave'])->name('contactsave');


Route::get('/login', [AuthController::class, 'showLoginForm'])->name('login');
Route::post('/login', [AuthController::class, 'login']);
Route::get('/logout', [AuthController::class, 'logout'])->name('logout');

// Authenticated Routes
Route::middleware(['auth'])->group(function () {
    // Dashboard
    Route::get('/dashboard', [HomeController::class, 'dashboard'])->name('dashboard');

    // Home
    Route::get('/profile', [HomeController::class, 'show'])->name('profile');
    Route::put('/profile', [HomeController::class, 'update'])->name('user.profile.update');
    Route::put('/profile/password', [HomeController::class, 'updatePassword'])->name('user.password.update');
    Route::post('/profile/picture', [HomeController::class, 'updatePicture'])->name('user.profile.picture');
    // Donation Routes

});
Route::prefix('donations')->group(function () {
        Route::get('/', [DonationController::class, 'index'])->name('donations.history');
        Route::get('/create', [DonationController::class, 'create'])->name('donations.create');
        Route::post('/', [DonationController::class, 'store'])->name('donations.store');
        Route::get('/{donation}', [DonationController::class, 'show'])->name('donations.show');
        Route::get('/{donation}/receipt', [DonationController::class, 'receipt'])->name('donations.receipt');
    });
