<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>User Dashboard</title>
<?php echo $__env->make('user.headlink', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<!-- DataTables CSS -->
<link rel="stylesheet" href="https://cdn.datatables.net/1.13.7/css/jquery.dataTables.min.css">
</head>
<body>
<?php echo $__env->make('user.head_sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<div class="content">
<div class="container">




<!-- Donation History Table -->
<div class="row justify-content-center">
    <div class="col-12">
        <div class="card shadow mb-4">
            <div class="card-header py-3 d-flex justify-content-between align-items-center">
                 <h1 class="h3 mb-0 text-gray-800">Your Donation History

</h1>
<p>Welcome back, <?php echo e(auth()->user()->name); ?>!</p>
                
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-bordered" id="donationsTable" width="100%" cellspacing="0">
                        <thead>
                            <tr>
                                <th>Date</th>
                                <th>Transaction ID</th>
                                <th>Amount</th>
                                <th>Payment Method</th>
                                <th>Status</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__empty_1 = true; $__currentLoopData = $donations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $donation): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr>
                                <td><?php echo e($donation->created_at->format('d-m-Y H:i')); ?></td>
                                <td><?php echo e($donation->transaction_id ?? 'N/A'); ?></td>
                                <td>₹<?php echo e(number_format($donation->amount, 2)); ?></td>
                                <td><?php echo e(ucfirst(str_replace('_', ' ', $donation->payment_gateway))); ?></td>
                                <td>
                                    <?php if($donation->status === 'completed'): ?>
                                        <span class="badge bg-success">Completed</span>
                                    <?php elseif($donation->status === 'pending'): ?>
                                        <span class="badge bg-warning">Pending</span>
                                    <?php else: ?>
                                        <span class="badge bg-danger">Failed</span>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <a href="<?php echo e(route('donations.show', $donation)); ?>" class="btn btn-sm btn-outline-primary">Details</a>
                                    <?php if($donation->status === 'completed'): ?>
                                        <?php if($donation && $donation->token): ?>
                                            <a href="<?php echo e(route('download.invoice', $donation->token)); ?>" class="btn btn-sm btn-outline-secondary">Download</a>
                                        <?php endif; ?>
                                    <?php else: ?>
                                        <button class="btn btn-sm btn-outline-secondary" disabled>Receipt</button>
                                    <?php endif; ?>
                                </td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td colspan="6" class="text-center">No donations found</td>
                            </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- End Donation History Table -->




</div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
<!-- jQuery and DataTables JS -->
<script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
<script src="https://cdn.datatables.net/1.13.7/js/jquery.dataTables.min.js"></script>
<script>
    $(document).ready(function() {
        $('#donationsTable').DataTable({
            paging: true,
            searching: true,
            ordering: true,
            info: true,
            lengthMenu: [10, 25, 50, 100],
            pageLength: 10,
            language: {
                search: "Search Donations:",
                lengthMenu: "Show _MENU_ entries",
                emptyTable: "No donations available."
            },
            columnDefs: [
                { orderable: false, targets: [5] }
            ]
        });
    });
</script>

</body>
</html>
<?php /**PATH /home1/jertabhumanity/public_html/resources/views/donation/index.blade.php ENDPATH**/ ?>