<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Thank You for Your Donation - <?php echo e(config('app.name')); ?></title>
</head>
<body style="margin: 0; padding: 0; background-color: #f4f4f4;">
    <div style="font-family: Arial, sans-serif; line-height: 1.6; color: #333333; max-width: 600px; margin: 0 auto; padding: 20px;">
        <!-- Logo Section -->
        <div style="text-align: center; margin-bottom: 20px;">
            <img src="https://www.jertabhumanity.com/site/public/home/logo2.png" alt="Laravel Logo" style="max-width: 150px; height: auto;">
        </div>

        <!-- Header -->
        <div style="background-color: #f8fafc; padding: 20px; border-radius: 8px; text-align: center;">
            <h1 style="font-size: 24px; color: #264668; margin: 0;">Thank You for Your Donation</h1>
        </div>

        <!-- Content -->
        <div style="padding: 20px; background-color: #ffffff; border: 1px solid #e2e8f0; border-radius: 8px; margin-top: 20px;">
            <p style="font-size: 16px;">Dear <?php echo e($donation->name); ?>,</p>
            <p style="font-size: 16px;">We sincerely appreciate your generous donation of <strong>₹<?php echo e(number_format($donation->amount, 2)); ?></strong> to <?php echo e(config('app.name')); ?>. Your support helps us continue our mission.</p>

            <!-- Donation Details -->
            <h2 style="font-size: 18px; color: #264668; margin-top: 20px;">Donation Details</h2>
            <table style="width: 100%; font-size: 14px; margin-top: 10px;">
                <tr>
                    <td style="padding: 8px 0; color: #4b5563;">Transaction ID:</td>
                    <td style="padding: 8px 0;"><?php echo e($donation->transaction_id); ?></td>
                </tr>
                <tr>
                    <td style="padding: 8px 0; color: #4b5563;">Date:</td>
                    <td style="padding: 8px 0;"><?php echo e($donation->created_at->format('d M Y h:i A')); ?></td>
                </tr>
                <tr>
                    <td style="padding: 8px 0; color: #4b5563;">Payment Method:</td>
                    <td style="padding: 8px 0;"><?php echo e(ucfirst($donation->payment_gateway)); ?></td>
                </tr>
            </table>



                        <h2 style="font-size: 18px; color: #264668; margin-top: 20px;">Login Detail</h2>
            <p style="font-size: 14px; margin: 10px 0;">
                User mail : Your mail address <br>
                password  : Your mail address
            </p>

            <!-- Billing Information -->
            <h2 style="font-size: 18px; color: #264668; margin-top: 20px;">Billing Information</h2>
            <p style="font-size: 14px; margin: 10px 0;">
                <?php echo e($donation->name); ?><br>
                <?php echo e($donation->address); ?><br>
                <?php echo e($donation->city); ?>, <?php echo e($donation->state); ?> - <?php echo e($donation->pincode); ?><br>
                India
            </p>
        </div>

        <!-- Buttons -->
        <div style="text-align: center; margin-top: 20px; display:flex;justify-content:space-evenly;align-item:center;">
            <div style="margin-bottom: 10px;">
                <a href="<?php echo e(url('/')); ?>" style="display: inline-block; padding: 10px 20px; background-color: #264668; color: #ffffff; text-decoration: none; border-radius: 5px; font-size: 14px;">Visit Our Website</a>
            </div>
            <div>
                <a href="<?php echo e(url('/donations/invoice/token/' . $donation->token)); ?>" style="display: inline-block; padding: 10px 20px; background-color: #d0a933; color: #ffffff; text-decoration: none; border-radius: 5px; font-size: 14px;">Download Invoice</a>
                
            </div>
        </div>

        <!-- Footer -->
        <div style="text-align: center; margin-top: 20px; font-size: 12px; color: #6b7280;">
            <p>With gratitude,<br><?php echo e(config('app.name')); ?></p>
            <p style="margin-top: 10px;">© <?php echo e(date('Y')); ?> <?php echo e(config('app.name')); ?>. All rights reserved.</p>
        </div>
    </div>
</body>
</html>
<?php /**PATH R:\jertab\Jertab\resources\views/emails/donation_invoice.blade.php ENDPATH**/ ?>