<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Video Management</title>
    <?php echo $__env->make('user.headlink', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <!-- DataTables CSS -->
    <link rel="stylesheet" href="https://cdn.datatables.net/1.13.7/css/jquery.dataTables.min.css">
    <style>
        .action-btns {
            display: flex;
            gap: 8px;
        }
        .btn-edit {
            background-color: #4CAF50;
            color: white;
            padding: 6px 12px;
            border: none;
            border-radius: 4px;
            cursor: pointer;
            text-decoration: none;
            font-size: 14px;
        }
        .btn-delete {
            background-color: #f44336;
            color: white;
            padding: 6px 12px;
            border: none;
            border-radius: 4px;
            cursor: pointer;
            font-size: 14px;
        }
        .btn-add {
            background-color: #2196F3;
            color: white;
            padding: 8px 16px;
            border: none;
            border-radius: 4px;
            cursor: pointer;
            text-decoration: none;
            display: inline-flex;
            align-items: center;
            gap: 5px;
        }
        .badge-high {
            background-color: #ffc107;
            color: #212529;
        }
        .badge-normal {
            background-color: #6c757d;
            color: white;
        }
        .video-url {
            max-width: 200px;
            white-space: nowrap;
            overflow: hidden;
            text-overflow: ellipsis;
            display: inline-block;
        }
        [title] {
            cursor: help;
            position: relative;
        }
        [title]:hover::after {
            content: attr(title);
            position: absolute;
            bottom: 100%;
            left: 50%;
            transform: translateX(-50%);
            background: #333;
            color: #fff;
            padding: 5px 10px;
            border-radius: 4px;
            font-size: 14px;
            white-space: nowrap;
            z-index: 100;
        }
        .description-cell {
            max-width: 200px;
            white-space: nowrap;
            overflow: hidden;
            text-overflow: ellipsis;
        }
    </style>
</head>
<body>
    <?php echo $__env->make('admin.head_sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <div class="content">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-12">
                    <div class="card shadow mb-4 animate__animated animate__fadeIn">
                        <div class="card-header py-3 d-flex justify-content-between align-items-center">
                            <h1 class="h3 mb-0 text-gray-800">Video Management</h1>
                            <div>
                                <a href="<?php echo e(route('videos.create')); ?>" class="btn btn-add">
                                    <i class="fas fa-plus"></i> Add Video
                                </a>
                                <a href="<?php echo e(route('admin.dashboard')); ?>" class="btn btn-secondary">
                                    <i class="fas fa-arrow-left"></i> Back to Dashboard
                                </a>
                            </div>
                        </div>
                        <div class="card-body">
                            <?php if(session('success')): ?>
                                <div class="alert alert-success alert-dismissible fade show" role="alert">
                                    <?php echo e(session('success')); ?>

                                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                                </div>
                            <?php endif; ?>

                            <div class="table-responsive">
                                <table class="table table-bordered" id="videosTable" width="100%" cellspacing="0">
                                    <thead>
                                        <tr>
                                            <th>#</th>
                                            <th>Category</th>
                                            <th>Highlight</th>
                                            <th>Heading</th>
                                            <th>Video URL</th>
                                            <th>Date Time</th>
                                            <th>Description</th>
                                            <th>Actions</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $__currentLoopData = $videos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $video): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr>
                                                <td><?php echo e($index + 1); ?></td>
                                                <td><?php echo e($video->category); ?></td>
                                                <td>
                                                    <?php if($video->hightlight == 1): ?>
                                                        <span class="badge badge-high">High</span>
                                                    <?php else: ?>
                                                        <span class="badge badge-normal">Normal</span>
                                                    <?php endif; ?>
                                                </td>
                                                <td>
                                                    <?php echo e(Str::limit($video->heading, 15)); ?>

                                                </td>
                                                <td>
                                                    <a href="<?php echo e($video->video_url); ?>" class="video-url" target="_blank" title="<?php echo e($video->video_url); ?>">
                                                        <?php echo e(Str::limit($video->video_url, 30)); ?>

                                                    </a>
                                                </td>
                                                <td><?php echo e(\Carbon\Carbon::parse($video->date_time)->format('d-m-Y')); ?></td>
                                                <td class="description-cell" title="<?php echo e($video->description); ?>">
                                                    <?php echo e(Str::limit($video->description, 15)); ?>

                                                </td>
                                                <td class="action-btns">
                                                    <a href="<?php echo e(route('videos.edit', $video->id)); ?>" class="btn-edit">
                                                        <i class="fas fa-edit"></i>
                                                    </a>
                                                    <form action="<?php echo e(route('videos.destroy', $video->id)); ?>" method="POST" style="display:inline;" onsubmit="return confirm('Are you sure you want to delete this video?');">
                                                        <?php echo csrf_field(); ?>
                                                        <?php echo method_field('DELETE'); ?>
                                                        <button type="submit" class="btn-delete">
                                                            <i class="fas fa-trash-alt"></i>
                                                        </button>
                                                    </form>
                                                </td>
                                            </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <!-- jQuery and DataTables JS -->
    <script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
    <script src="https://cdn.datatables.net/1.13.7/js/jquery.dataTables.min.js"></script>
    <script src="https://kit.fontawesome.com/a076d05399.js" crossorigin="anonymous"></script>

    <script>
        $(document).ready(function() {
            $('#videosTable').DataTable({
                paging: true,
                searching: true,
                ordering: true,
                info: true,
                lengthMenu: [10, 25, 50, 100],
                pageLength: 10,
                language: {
                    search: "Search Videos:",
                    lengthMenu: "Show _MENU_ entries",
                    emptyTable: "No videos available."
                },
                columnDefs: [
                    { orderable: false, targets: [0, 7] }, // Disable sorting for # and Actions columns
                    { width: "5%", targets: [0] }, // Serial number column
                    { width: "10%", targets: [2, 7] }, // Highlight and Actions columns
                    { width: "15%", targets: [1, 3, 4, 5] } // Other columns
                ],
                order: [[1, 'asc']] // Default sort by Category
            });
        });
    </script>
</body>
</html>
<?php /**PATH /home1/jertabhumanity/public_html/resources/views/admin/videos/index.blade.php ENDPATH**/ ?>