<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Edit Banner</title>
    <?php echo $__env->make('user.headlink', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <style>
        .form-container {
            max-width: 800px;
            margin: 0 auto;
        }
        .form-group {
            margin-bottom: 1.5rem;
        }
        .form-label {
            display: block;
            margin-bottom: 0.5rem;
            font-weight: 500;
        }
        .form-control {
            width: 100%;
            padding: 0.75rem;
            border: 1px solid #ced4da;
            border-radius: 0.375rem;
            transition: border-color 0.15s ease-in-out;
        }
        .form-control:focus {
            border-color: #86b7fe;
            outline: 0;
            box-shadow: 0 0 0 0.25rem rgba(13, 110, 253, 0.25);
        }
        textarea.form-control {
            min-height: 120px;
            resize: vertical;
        }
        .btn-submit {
            background-color: #28a745;
            color: white;
            padding: 0.75rem 1.5rem;
            border: none;
            border-radius: 0.375rem;
            cursor: pointer;
            transition: background-color 0.15s ease-in-out;
        }
        .btn-submit:hover {
            background-color: #218838;
        }
        .preview-container {
            display: flex;
            gap: 20px;
            align-items: flex-start;
            margin: 15px 0;
        }
        .current-image, .new-image-preview {
            display: flex;
            flex-direction: column;
        }
        .current-image img, .new-image-preview img {
            max-width: 200px;
            max-height: 150px;
            border-radius: 0.375rem;
            margin-top: 10px;
        }
        .image-label {
            font-weight: 500;
            color: #495057;
        }
        .action-btns {
            display: flex;
            gap: 15px;
            margin-top: 1.5rem;
        }
        .btn-secondary {
            background-color: #6c757d;
            color: white;
            padding: 0.75rem 1.5rem;
            border: none;
            border-radius: 0.375rem;
            cursor: pointer;
            text-decoration: none;
            display: inline-flex;
            align-items: center;
            justify-content: center;
        }
        .btn-secondary:hover {
            background-color: #5c636a;
        }
    </style>
</head>
<body>
    <?php echo $__env->make('admin.head_sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <div class="content">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-md-12">
                    <div class="card animate__animated animate__fadeIn">
                        <div class="card-header d-flex justify-content-between align-items-center">
                            <h4>Edit Banner</h4>
                            <a href="<?php echo e(route('admin.banner')); ?>" class="btn btn-secondary">
                                <i class="fas fa-arrow-left"></i> Back to Banners
                            </a>
                        </div>
                        <div class="card-body">
                            <form method="POST" action="<?php echo e(route('banners.update', $banner->id)); ?>" enctype="multipart/form-data" class="form-container">
                                <?php echo csrf_field(); ?>
                                <?php echo method_field('PUT'); ?>

                                <div class="form-group">
                                    <label for="name" class="form-label">Banner Name</label>
                                    <input type="text" id="name" name="name" class="form-control" value="<?php echo e(old('name', $banner->name)); ?>" required>
                                    <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="text-danger mt-1"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>

                                <div class="form-group">
                                    <label class="form-label">Banner Image</label>
                                    <div class="preview-container">
                                        <div class="current-image">
                                            <span class="image-label">Current Image:</span>
                                            <img src="<?php echo e(asset($banner->image)); ?>" alt="Current Banner Image">
                                        </div>
                                        <div class="new-image-preview">
                                            <span class="image-label">New Image Preview:</span>
                                            <img id="newImagePreview" style="display: none;">
                                        </div>
                                    </div>
                                    <input type="file" id="image" name="image" class="form-control mt-2" accept="image/*" onchange="previewNewImage()">
                                    <small class="text-muted">Leave blank to keep current image</small>
                                    <?php $__errorArgs = ['image'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="text-danger mt-1"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>

                                <div class="form-group">
                                    <label for="description" class="form-label">Description</label>
                                    <textarea id="description" name="description" class="form-control" rows="4"><?php echo e(old('description', $banner->description)); ?></textarea>
                                    <?php $__errorArgs = ['description'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="text-danger mt-1"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>

                                <div class="action-btns">
                                    <button type="submit" class="btn btn-submit">
                                        <i class="fas fa-save"></i> Update Banner
                                    </button>
                                    <a href="<?php echo e(route('admin.banner')); ?>" class="btn btn-secondary">
                                        <i class="fas fa-times"></i> Cancel
                                    </a>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://kit.fontawesome.com/a076d05399.js" crossorigin="anonymous"></script>

    <script>
        function previewNewImage() {
            const preview = document.getElementById('newImagePreview');
            const file = document.querySelector('input[type=file]').files[0];
            const reader = new FileReader();

            reader.onloadend = function() {
                preview.src = reader.result;
                preview.style.display = 'block';
            }

            if (file) {
                reader.readAsDataURL(file);
            } else {
                preview.src = '';
                preview.style.display = 'none';
            }
        }
    </script>
</body>
</html>
<?php /**PATH R:\jertab\Jertab\resources\views/admin/banners/edit.blade.php ENDPATH**/ ?>