<!DOCTYPE html>
<html lang="en">
<head>
    <?php echo $__env->make('googletag', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Jertab Humanity | Restoring Dignity & Hope Through Compassion</title>
<meta name="description" content="Jertab Humanity provides food, shelter, financial aid, and resources to those in need, helping rebuild lives and small businesses with kindness and dignity.">
<link rel="shortcut icon" href="<?php echo e(asset('home/logo2.png')); ?>" type="image/x-icon">

  <!-- Bootstrap & Icons -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet" />
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.3/font/bootstrap-icons.css" />
<?php echo $__env->make('header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
  <style>
    body {
      background-color: #000;
      font-family: 'Segoe UI', sans-serif;
    }

    .contact-container {

      margin: 60px auto;
      padding: 30px;
    /* height: 100px; */
      border-radius: 30px;
    }

    .info-box, .form-box {
      background-color: #e0e0e0;
      border-radius: 30px;
      padding: 25px;
      box-shadow: 0 4px 12px rgba(0, 0, 0, 0.2);
      height: 100%;
    }

    .info-box h3 {
      font-weight: bold;
      margin-bottom: 30px;
    }

    .info-item {
      display: flex;
      align-items: center;
      margin-bottom: 50px;
      padding-bottom: 15px;
      border-bottom: 1px solid #aaa;
    }

    .info-item i {
      font-size: 22px;
      background-color: #274768;
      color: #fff;
      padding: 10px 15px;
      border-radius: 50%;
      margin-right: 15px;
    }

    .info-item a {
      text-decoration: none;
      color: #000;
    }

    .info-item a:hover {
      color: #0d6efd;
    }

    .btn-send {
      background-color: #0000ff;
      color: white;
      font-weight: bold;
      border: none;
      border-radius: 15px;
      padding: 10px 30px;
      transition: 0.3s ease-in-out;
    }

    .btn-send:hover {
      background-color: #0000cc;
    }
    .carousel {
  position: relative;
  overflow: hidden;
  width: 100vw;
  height: 90vh;
}
.slider-control{
       position: absolute;
            top: 50%;
            width: 100%;
            display: flex;
            justify-content: space-between;
            transform: translateY(-50%);
}

.slider-track {
  display: flex;
  width: 500vw; /* 5 slides * 100vw */
  animation: slideCarousel 10s infinite;
}

.slide {
  width: 100vw;
  height: 90vh;
  flex-shrink: 0;
}

.slide img {
width: 100%;
  height: 100%;
  object-fit: cover;
}

/* Animation */
@keyframes slideCarousel {
  0%    { transform: translateX(0vw); }
  20%   { transform: translateX(0vw); }
  25%   { transform: translateX(-100vw); }
  40%   { transform: translateX(-100vw); }
  45%   { transform: translateX(-200vw); }
  60%   { transform: translateX(-200vw); }
  65%   { transform: translateX(-300vw); }
  80%   { transform: translateX(-300vw); }
  85%   { transform: translateX(-400vw); }
  100%  { transform: translateX(-400vw); }
}

  </style>
</head>
<body>

<!-- Bootstrap CSS -->


<style>
  .contact-banner-section {
    background-color: #000;
    padding: 3rem 0;
    color: #fff;
  }

  .banner-wrapper-con {
    position: relative;
    overflow: hidden;
    margin-top: 80px;
    border-radius: 40px;
  }

  .banner-wrapper-con img {
    width: 100%;
    height: auto;
    border-radius: 40px;
    object-fit: cover;
  }

  .banner-text-con {
    position: absolute;
    top: 50%;
    left: 50%;
    transform: translate(-50%, -50%);
    text-align: center;
    padding: 1rem;
  }

  .banner-text-con h1 {
    font-size: 3rem;
    font-weight: 700;
    text-shadow: 2px 2px 6px rgba(0, 0, 0, 0.7);
  }

  .banner-text-con a.btn-primary {
    background-color: #274768;
    border: none;
    border-radius: 25px;
    color: #fff !important;
    font-weight: 500;
    padding: 0.6rem 1.5rem;
    font-size: 1.1rem;
  }
 .banner-text-con .btn{
     color: #fff;
 }
  .banner-text-con a.btn-primary:hover {
    background-color: #1e00b8;
  }

  .contact-footer-text {
    font-size: 1.2rem;
    margin-top: 2rem;
    text-align: center;
  }
  .btn-save {
  background-color: #274768;  /* Deep blue */
  color: #fff;
  border: none;
  padding: 0.6rem 1.5rem;
  border-radius: 25px;
  font-weight: 500;
  font-size: 1.1rem;
  transition: background-color 0.3s ease;
}

.btn-save:hover {
  background-color: #1e00b8;  /* Slightly darker on hover */
}

  /* Responsive adjustments */
  @media (max-width: 768px) {
    .banner-text-con h1 {
      font-size: 2rem;
    }

    .banner-text-con a.btn-primary {
      font-size: .6rem;
      padding: 0.5rem 1.2rem;
    }
  }

  @media (max-width: 480px) {
    .banner-text-con {
      padding: 0.5rem;
    }

    .banner-text-con h1 {
      font-size: 1rem;
    }

    .contact-footer-text {
      font-size: 1rem;
    }

  }
</style>
<?php echo $__env->make('menu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<section class="contact-banner-section">
  <div class="container">
    <div class="banner-wrapper-con">
          <img src="<?php echo e(asset('assets/images/about/contactus-banner-jertab.webp')); ?>" class="d-block w-100 img-fluid" alt="Slide 1">
      <div class="banner-text-con">
        <h1>CONTACT US</h1>
        <a href="/" class="btn btn-primary mt-3">Home › Contact Us</a>
      </div>
    </div>

    <div class="contact-footer-text text-white">
     <h3> Any questions? Feel free drop us a Message.</h3>
    </div>
  </div>
</section>

<section class="ddf">
  <div class="container contact-container">
    <div class="row g-4">
      <!-- Left Column: Get Touch In -->
      <div class="col-md-4">
        <div class="info-box">
          <h3>Get Touch In</h3>

          <div class="info-item">
            <i class="bi bi-envelope-fill"></i>
            <a href="mailto:jertabhumanity@gmail.com">Email :<br>jertabhumanity@gmail.com</a>
          </div>

          <!--<div class="info-item">-->
          <!--  <i class="bi bi-telephone-fill"></i>-->
          <!--  <a href="123456789">Phone :<br>123456789</a>-->
          <!--</div>-->

          <div class="info-item">
            <i class="bi bi-globe"></i>
            <a href="https://www.jertabhumanity.com" target="_blank">Website :<br>www.jertabhumanity.com</a>
          </div>
        </div>
      </div>

      <!-- Right Column: Contact Form -->
      <div class="col-md-8">
        <div class="form-box">
            <?php if(session('success')): ?>
    <div class="alert alert-success">
        <?php echo e(session('success')); ?>

    </div>
<?php endif; ?>

<?php if(session('error')): ?>
    <div class="alert alert-danger">
        <?php echo e(session('error')); ?>

    </div>
<?php endif; ?>
<form action="<?php echo e(route('contactsave')); ?>" method="POST">
    <?php echo csrf_field(); ?>

            <div class="mb-3">
              <label for="name" class="form-label">Your Name *</label>
              <input type="text" name="name" class="form-control rounded-3" id="name" required />
            </div>
            <div class="mb-3">
              <label for="email" class="form-label">Your Email *</label>
              <input type="email" name="email" class="form-control rounded-3" id="email" required />
            </div>
            <div class="mb-3">
              <label for="phone" class="form-label">Your Phone no *</label>
              <input type="number" name="phone" class="form-control rounded-3" id="phone" required />
            </div>
            <div class="mb-3">
              <label for="message" class="form-label">Your Message *</label>
              <textarea name="message" class="form-control rounded-3" id="message" rows="4" required></textarea>
            </div>
            
            <div class="g-recaptcha mb-3" data-sitekey="<?php echo e(config('services.recaptcha.site_key')); ?>"></div>
            <?php if($errors->has('captcha')): ?>
                <small class="text-danger d-block"><?php echo e($errors->first('captcha')); ?></small>
            <?php endif; ?>
            
              <button type="submit" class="btn btn-save">Submit Query</button>
          </form>
        </div>
      </div>
    </div>
  </div>
  </section>
  <?php echo $__env->make('footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
  <!-- JavaScript: Form Submit -->
<script src="https://www.google.com/recaptcha/api.js" async defer></script>

</body>
</html>
<?php /**PATH /home1/jertabhumanity/public_html/resources/views/contact.blade.php ENDPATH**/ ?>