<!DOCTYPE html>
<html lang="en">
<head>
      <meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Jertab Humanity | Restoring Dignity & Hope Through Compassion</title>
<meta name="description" content="Jertab Humanity provides food, shelter, financial aid, and resources to those in need, helping rebuild lives and small businesses with kindness and dignity.">
<link rel="shortcut icon" href="<?php echo e(asset('home/logo2.png')); ?>" type="image/x-icon">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/sweetalert2@11/dist/sweetalert2.min.css">
    <script src="https://checkout.razorpay.com/v1/checkout.js"></script>
    <?php echo $__env->make('header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <style>
        .donatepage{
            margin-top: 190px;
        }
        .form-group .form-control{
                border-color: #254566;
    border-radius: 30px;
    padding: 8px 22px !important;
        }
        .form-group {
    margin-bottom: 30px;
    display: flex;
    align-items: start !important;
    column-gap: 24px;
    flex-direction: column;
        }
        .doncard{
            padding: 20px 40px;
            margin-bottom: 30px;
    border-radius: 30px;
        }
        .doonatbtn{
            background: linear-gradient(45deg, #274768, #d0a933);
    color: white;
    border: none;
    transition: .5s;
    padding: 20px 20px;
        }
        .amtrad {
            padding: 8px !important;
        }
        .amtrad:hover{
             background: linear-gradient(45deg, #d0a933, #d0a933);
        }
        .checkdonate{
            border:2px solid #254566;
        }
        .card-header{
            font-size: 2rem;
        }

        /* Style for selected amount radio button */
.btn-group .btn.amtrad.active {
    background: linear-gradient(45deg, #d0a933, #d0a933) !important;
    color: white !important;
    border-color: #d0a933 !important;
}

/* Style for selected payment gateway */
.form-check.active {
    background: linear-gradient(45deg, #274768, #d0a933) !important;
    border-color: #d0a933 !important;
    color: white !important;
}

.form-check.active .form-check-input {
    accent-color: white;
}


/* Responsive button group styles */
@media (max-width: 767.98px) {
    .btn-group-toggle {
        flex-direction: column;
    }
    .btn-group-toggle .btn {
        width: 100%;
        margin: 5px 0;
    }
    .doncard {
        padding: 20px !important;
    }
    .donatepage {
    margin-top: 120px;
}
.donatepage .col-md-7{
    margin-top: 30px;
}
    .form-group {
        row-gap: 10px;
    }
}

/* Ensure buttons have equal width on desktop */
@media (min-width: 768px) {
    .btn-group-toggle .btn {
        flex: 1 0 auto;
    }
}
    </style>
</head>
<body>
    <?php echo $__env->make('menu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<div class="container donatepage">
    <div class="row justify-content-center">
         <div class="col-md-5">
            <img src="<?php echo e(asset('assets/images/donatee.png')); ?>" alt="">
         </div>
        <div class="col-md-7">
            <div class="card doncard">
                <div class="card-header">Make a Donation</div>

                <div class="card-body">
                    <?php if($errors->any()): ?>
                        <div class="alert alert-danger">
                            <ul>
                                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <li><?php echo e($error); ?></li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </ul>
                        </div>
                    <?php endif; ?>

                    <?php if(session('success')): ?>
                        <div class="alert alert-success">
                            <?php echo e(session('success')); ?>

                            <?php if(session('donation')): ?>
                                <div class="mt-2">
                                    Donation details: <?php echo e(session('donation')); ?>

                                </div>
                            <?php endif; ?>
                        </div>
                    <?php endif; ?>

                    <form id="donationForm" method="POST" action="<?php echo e(route('donate.process')); ?>">
                        <?php echo csrf_field(); ?>
                        <input type="hidden" name="amount" id="consolidated_amount">
                        <div class="row">
                            <div class="col-12 col-md-12">
                        <div class="form-group">
                               <div class="row">
                                  <div class="col-12 col-md-10">
                            <label for="amount">Donation Amount (₹)</label>
                                  </div>

                                <div class="col-12 col-md-10">
    <div class="row g-2" data-toggle="buttons">
        <?php $__currentLoopData = [1000, 3000, 5000, 10000]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $amount): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="col-6 col-sm-3">
                <label class="btn btn-outline-primary amtrad w-100">
                    <input type="radio" name="amount_radio" value="<?php echo e($amount); ?>"
                        <?php echo e(old('amount') == $amount ? 'checked' : ''); ?>>
                    ₹<?php echo e(number_format($amount)); ?>

                </label>
            </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </div>
</div>
                               <div class="col-12 col-md-10">
                            <div class="mt-2">
                                <input type="number" class="form-control <?php $__errorArgs = ['custom_amount'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                       id="custom_amount" name="custom_amount" placeholder="Or enter custom amount (min ₹100)"
                                       min="100" value="<?php echo e(old('custom_amount')); ?>">
                                <?php $__errorArgs = ['custom_amount'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                               </div>
                            </div>
                        </div>
                        </div>

                         <div class="col-12 col-md-12">
                             <label>Payment Gateway</label>
                       <div class="form-group mt-3" style="flex-direction: row;">

    <div class="form-check" style="border:2px solid #000; padding:15px 20px 15px 40px;border-radius:40px;">
    <input class="form-check-input" type="radio" name="gateway" id="razorpay"
           value="razorpay" <?php echo e(old('gateway', 'razorpay') == 'razorpay' ? 'checked' : ''); ?>>
    <label class="form-check-label d-flex align-items-center gap-2" for="razorpay">
        <img src="<?php echo e(asset('assets/images/razorpay.png')); ?>" alt="Razorpay" style="height: 40px;margin-top:-10px;">
    </label>
</div>
<div class="form-check" style="border:2px solid #000;padding:20px 20px 10px 40px;border-radius:40px;">
    <input class="form-check-input" type="radio" name="gateway" id="stripe"
           value="stripe" <?php echo e(old('gateway') == 'stripe' ? 'checked' : ''); ?>>
    <label class="form-check-label d-flex align-items-center gap-2" for="stripe">
        <img src="<?php echo e(asset('assets/images/stripe.png')); ?>" alt="Stripe" style="height: 40px;margin-top:-10px;">
    </label>
</div>
    <?php $__errorArgs = ['gateway'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
        <div class="text-danger small"><?php echo e($message); ?></div>
    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
</div>
                         </div>
 <div class="col-12 col-md-12">
                          <h5>Donor Information</h5>
 </div>
                          <div class="col-12 col-md-6">
                            <div class="form-group">
                                <label for="name">Full Name</label>
                                <input type="text" class="form-control <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                       id="name" name="name" value="<?php echo e(old('name', $user->name ?? '')); ?>" required>
                                <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                          </div>
                           <div class="col-12 col-md-6">
                            <div class="form-group">
                                <label for="email">Email</label>
                                <input type="email" class="form-control <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                       id="email" name="email" value="<?php echo e(old('email', $user->email ?? '')); ?>" required>
                                <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                           </div>
                            <div class="col-12 col-md-6">
                            <div class="form-group">
                                <label for="phone">Phone Number</label>
                                <input type="tel" class="form-control <?php $__errorArgs = ['phone'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                       id="phone" name="phone" value="<?php echo e(old('phone', $user->phone ?? '')); ?>" required>
                                <?php $__errorArgs = ['phone'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                            </div>
                             <div class="col-12 col-md-6">
                            <div class="form-group">
                                <label for="address">Address</label>
                                <textarea style="height: 30px;" class="form-control <?php $__errorArgs = ['address'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                          id="address" name="address" rows="3" required><?php echo e(old('address', $user->address ?? '')); ?></textarea>
                                <?php $__errorArgs = ['address'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                             </div>
                        </div>

                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="state">State</label>
                                        <select class="form-control <?php $__errorArgs = ['state'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                id="state" name="state" required>
                                            <option value="">Select State</option>
                                            <?php $__currentLoopData = ['Maharashtra', 'Delhi', 'Karnataka', 'Tamil Nadu', 'Uttar Pradesh']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $state): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($state); ?>"
                                                    <?php echo e(old('state', $user->state ?? '') == $state ? 'selected' : ''); ?>>
                                                    <?php echo e($state); ?>

                                                </option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                        <?php $__errorArgs = ['state'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <div class="invalid-feedback"><?php echo e($message); ?></div>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="city">City</label>
                                        <input type="text" class="form-control <?php $__errorArgs = ['city'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                               id="city" name="city" value="<?php echo e(old('city', $user->city ?? '')); ?>" required>
                                        <?php $__errorArgs = ['city'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <div class="invalid-feedback"><?php echo e($message); ?></div>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="pincode">PIN Code</label>
                                     <input type="text" class="form-control mini <?php $__errorArgs = ['pincode'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
       id="pincode" name="pincode" value="<?php echo e(old('pincode', $user->pincode ?? '')); ?>"
       pattern="\d{6}"
       minlength="6" maxlength="6"
       title="Please enter exactly 6 digits"
       required>
                                        <?php $__errorArgs = ['pincode'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <div class="invalid-feedback"><?php echo e($message); ?></div>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                </div>
                            </div>

                            <?php if(auth()->guard()->guest()): ?>
                            <div class="form-check mt-3">
                                <input class="form-check-input checkdonate" type="checkbox" name="create_account"
                                       id="create_account" <?php echo e(old('create_account') ? 'checked' : ''); ?>>
                                <label class="form-check-label" for="create_account">
                                    Create an account for future donations
                                </label>
                            </div>
                            <?php endif; ?>

                        <button type="submit" class="btn btn-primary mt-3 doonatbtn">Donate Now</button>
                    </form>
                     </div>
                </div>
        </div>
            </div>
        </div>
    </div>
</div>
<?php echo $__env->make('footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<script>
    document.addEventListener('DOMContentLoaded', function() {
    // Handle amount selection
    const amountRadios = document.querySelectorAll('input[name="amount_radio"]');
    const customAmount = document.getElementById('custom_amount');
    const consolidatedAmount = document.getElementById('consolidated_amount');

    amountRadios.forEach(radio => {
        radio.addEventListener('change', function() {
            // Remove active class from all amount buttons
            document.querySelectorAll('.btn.amtrad').forEach(btn => {
                btn.classList.remove('active');
            });

            // Add active class to selected button's parent label
            if (this.checked) {
                this.closest('.amtrad').classList.add('active');
                consolidatedAmount.value = this.value;
                customAmount.value = '';
            }
        });

        // Initialize active state if already selected
        if (radio.checked) {
            radio.closest('.amtrad').classList.add('active');
            consolidatedAmount.value = radio.value;
        }
    });

    // Handle custom amount input
    customAmount.addEventListener('input', function() {
        if (this.value) {
            // Clear radio selections
            amountRadios.forEach(radio => {
                radio.checked = false;
                radio.closest('.amtrad').classList.remove('active');
            });
            consolidatedAmount.value = this.value;
        }
    });

    // Handle gateway selection
    const gatewayRadios = document.querySelectorAll('input[name="gateway"]');
    gatewayRadios.forEach(radio => {
        radio.addEventListener('change', function() {
            // Remove active class from all gateway options
            document.querySelectorAll('.form-check').forEach(div => {
                div.classList.remove('active');
            });

            // Add active class to selected gateway's parent div
            if (this.checked) {
                this.closest('.form-check').classList.add('active');
            }
        });

        // Initialize active state if already selected
        if (radio.checked) {
            radio.closest('.form-check').classList.add('active');
        }
    });

    // PIN code validation
    document.getElementById('pincode').addEventListener('input', function(e) {
        this.value = this.value.replace(/\D/g, '').slice(0, 6);
    });

    // Form submission
    const form = document.getElementById('donationForm');
    form.addEventListener('submit', function(e) {
        e.preventDefault();

        // Validate amount
        const selectedRadio = document.querySelector('input[name="amount_radio"]:checked');
        const customAmountValue = customAmount.value;
        let amount;

        if (selectedRadio) {
            amount = selectedRadio.value;
        } else if (customAmountValue && parseInt(customAmountValue) >= 100) {
            amount = customAmountValue;
        } else {
            Swal.fire({
                icon: 'error',
                title: 'Invalid Amount',
                text: 'Please select or enter a valid amount (minimum ₹100)'
            });
            return;
        }

        // Set the consolidated amount
        consolidatedAmount.value = amount;

        // Get the selected gateway
        const gateway = document.querySelector('input[name="gateway"]:checked').value;

        // If Stripe, submit the form normally
        if (gateway === 'stripe') {
            Swal.fire({
                title: 'Processing Payment',
                text: 'Please wait while we process your donation...',
                allowOutsideClick: false,
                didOpen: () => {
                    Swal.showLoading();
                }
            });
            form.submit();
            return;
        }

        // For Razorpay, handle with AJAX
        Swal.fire({
            title: 'Processing Payment',
            text: 'Please wait while we process your donation...',
            allowOutsideClick: false,
            didOpen: () => {
                Swal.showLoading();
            }
        });

        fetch(form.action, {
            method: 'POST',
            headers: {
                'Accept': 'application/json',
                'Content-Type': 'application/x-www-form-urlencoded',
                'X-CSRF-TOKEN': document.querySelector('input[name="_token"]').value
            },
            body: new URLSearchParams(new FormData(form))
        })
        .then(response => {
            if (!response.ok) {
                throw new Error('Network response was not ok');
            }
            return response.json();
        })
        .then(data => {
            if (data.success && data.options) {
                const razorpayOptions = {
                    key: data.options.key,
                    amount: data.options.amount,
                    currency: data.options.currency,
                    name: data.options.name,
                    description: data.options.description,
                    image: data.options.image,
                    order_id: data.options.order_id,
                    prefill: data.options.prefill,
                    notes: data.options.notes,
                    theme: data.options.theme,
                    handler: function(response) {
                        handleRazorpayResponse(response, data.options);
                    },
                    modal: {
                        ondismiss: function() {
                            Swal.close();
                            console.log('Payment window closed');
                        }
                    }
                };

                const rzp = new Razorpay(razorpayOptions);
                rzp.open();

                rzp.on('payment.failed', function(response) {
                    Swal.fire({
                        icon: 'error',
                        title: 'Payment Failed',
                        text: 'Payment failed. Please try again. Error: ' +
                            (response.error.description || 'Unknown error')
                    });
                });
            } else {
                throw new Error(data.message || 'Invalid response from server');
            }
        })
        .catch(error => {
            Swal.fire({
                icon: 'error',
                title: 'Error',
                text: 'An error occurred: ' + error.message
            });
        });
    });

    function handleRazorpayResponse(response, options) {
        Swal.fire({
            title: 'Processing Payment',
            text: 'Please wait while we process your donation...',
            allowOutsideClick: false,
            didOpen: () => {
                Swal.showLoading();
            }
        });

        const callbackForm = document.createElement('form');
        callbackForm.method = 'POST';
        callbackForm.action = '<?php echo e(route("razorpay.callback")); ?>';

        const csrfInput = document.createElement('input');
        csrfInput.type = 'hidden';
        csrfInput.name = '_token';
        csrfInput.value = document.querySelector('input[name="_token"]').value;
        callbackForm.appendChild(csrfInput);

        const inputs = {
            'razorpay_payment_id': response.razorpay_payment_id,
            'razorpay_order_id': response.razorpay_order_id,
            'razorpay_signature': response.razorpay_signature,
            'amount': options.amount
        };

        for (const [name, value] of Object.entries(inputs)) {
            const input = document.createElement('input');
            input.type = 'hidden';
            input.name = name;
            input.value = value;
            callbackForm.appendChild(input);
        }

        document.body.appendChild(callbackForm);
        callbackForm.submit();
    }
});
</script>
</body>
</html>
<?php /**PATH R:\jertab\Jertab\resources\views/donation/form.blade.php ENDPATH**/ ?>