<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Admin Dashboard</title>
<?php echo $__env->make('user.headlink', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<!-- Include Chart.js -->
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
</head>
<body>
<?php echo $__env->make('admin.head_sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<div class="content">
<div class="container">
<div class="row justify-content-center">
<div class="col-md-12">
<div class="card animate__animated animate__fadeIn">
<div class="card-header">
<h4>Admin Dashboard</h4>
</div>
<div class="card-body">
<p>Welcome back, <?php echo e(auth()->user()->name); ?>!</p>
<div class="row mt-4">
<div class="col-md-3 mb-4">
<div class="card h-100">
<div class="card-body text-center">
<h5 class="card-title">Total Users</h5>
<p class="btn btn-primary"><?php echo e($userCount); ?></p>
</div>
</div>
</div>
<div class="col-md-3 mb-4">
<div class="card h-100">
<div class="card-body text-center">
<h5 class="card-title">Total Contacts</h5>
<p class="btn btn-primary"><?php echo e($contactCount); ?></p>
</div>
</div>
</div>
<div class="col-md-3 mb-4">
<div class="card h-100">
<div class="card-body text-center">
<h5 class="card-title">Total Donations</h5>
<p class="btn btn-primary"><?php echo e($donationCount); ?></p>
</div>
</div>
</div>
<div class="col-md-3 mb-4">
<div class="card h-100">
<div class="card-body text-center">
<h5 class="card-title">Total Amount</h5>
<p class="btn btn-primary">₹ <?php echo e(number_format($totalDonations, 2)); ?></p>
</div>
</div>
</div>
</div>

<!-- Bar Chart Section -->
<div class="row mt-4">
<div class="col-md-12">
<div class="card">
<div class="card-header">
<h5>Donations by Month</h5>
</div>
<div class="card-body">
<canvas id="donationsChart" height="100"></canvas>
</div>
</div>
</div>
</div>

</div>
</div>
</div>
</div>
</div>
</div>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>

<script>
// Bar Chart
document.addEventListener('DOMContentLoaded', function() {
    const ctx = document.getElementById('donationsChart').getContext('2d');
    const donationsData = <?php echo json_encode($donationsByMonth, 15, 512) ?>;

    // Prepare labels and data
    const months = ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec'];
    const data = Array(12).fill(0);

    Object.keys(donationsData).forEach(month => {
        data[month - 1] = donationsData[month];
    });

    const chart = new Chart(ctx, {
        type: 'bar',
        data: {
            labels: months,
            datasets: [{
                label: 'Donation Amount ($)',
                data: data,
                backgroundColor: 'rgba(54, 162, 235, 0.5)',
                borderColor: 'rgba(54, 162, 235, 1)',
                borderWidth: 1
            }]
        },
        options: {
            scales: {
                y: {
                    beginAtZero: true
                }
            }
        }
    });
});
</script>

</body>
</html>
<?php /**PATH /home1/jertabhumanity/public_html/resources/views/admin/dashboard.blade.php ENDPATH**/ ?>