<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Contact Details</title>
    <?php echo $__env->make('user.headlink', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <style>
        .contact-details {
            max-width: 800px;
            margin: 0 auto;
        }
        .detail-group {
            margin-bottom: 1.5rem;
        }
        .detail-label {
            font-weight: 500;
            color: #495057;
            margin-bottom: 0.5rem;
        }
        .detail-value {
            padding: 0.75rem;
            background-color: #f8f9fa;
            border-radius: 0.375rem;
            word-break: break-word;
        }
        .message-content {
            white-space: pre-wrap;
        }
    </style>
</head>
<body>
    <?php echo $__env->make('admin.head_sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <div class="content">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-md-10">
                    <div class="card shadow mb-4 animate__animated animate__fadeIn">
                        <div class="card-header py-3 d-flex justify-content-between align-items-center">
                            <h1 class="h3 mb-0 text-gray-800">Contact Details</h1>
                            <a href="<?php echo e(route('admin.contacts.index')); ?>" class="btn btn-secondary">
                                <i class="fas fa-arrow-left"></i> Back to List
                            </a>
                        </div>
                        <div class="card-body">
                            <div class="contact-details">
                                <div class="detail-group">
                                    <div class="detail-label">Name</div>
                                    <div class="detail-value"><?php echo e($contact->name); ?></div>
                                </div>

                                <div class="detail-group">
                                    <div class="detail-label">Email</div>
                                    <div class="detail-value"><?php echo e($contact->email); ?></div>
                                </div>

                                <div class="detail-group">
                                    <div class="detail-label">Phone</div>
                                    <div class="detail-value"><?php echo e($contact->phone); ?></div>
                                </div>

                                <div class="detail-group">
                                    <div class="detail-label">Submitted At</div>
                                    <div class="detail-value"><?php echo e($contact->created_at->format('d-m-Y H:i')); ?></div>
                                </div>

                                <div class="detail-group">
                                    <div class="detail-label">Status</div>
                                    <div class="detail-value">
                                        <?php if($contact->read_at): ?>
                                            Read on <?php echo e($contact->read_at->format('d-m-Y H:i')); ?>

                                        <?php else: ?>
                                            <span class="badge bg-primary">New</span>
                                        <?php endif; ?>
                                    </div>
                                </div>

                                <div class="detail-group">
                                    <div class="detail-label">Message</div>
                                    <div class="detail-value message-content"><?php echo e($contact->message); ?></div>
                                </div>
                            </div>

                            <div class="mt-4 d-flex justify-content-between">
                                <form action="<?php echo e(route('admin.contacts.markAsRead', $contact->id)); ?>" method="POST">
                                    <?php echo csrf_field(); ?>
                                    <?php if($contact->read_at): ?>
                                        <button type="button" class="btn btn-secondary" disabled>
                                            <i class="fas fa-check"></i> Already Read
                                        </button>
                                    <?php else: ?>
                                        <button type="submit" class="btn btn-primary">
                                            <i class="fas fa-check"></i> Mark as Read
                                        </button>
                                    <?php endif; ?>
                                </form>

                                <form action="<?php echo e(route('admin.contacts.destroy', $contact->id)); ?>" method="POST">
                                    <?php echo csrf_field(); ?>
                                    <?php echo method_field('DELETE'); ?>
                                    <button type="submit" class="btn btn-danger" onclick="return confirm('Are you sure you want to delete this contact?');">
                                        <i class="fas fa-trash-alt"></i> Delete
                                    </button>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://kit.fontawesome.com/a076d05399.js" crossorigin="anonymous"></script>
</body>
</html>
<?php /**PATH R:\jertab\Jertab\resources\views/admin/conshow.blade.php ENDPATH**/ ?>