<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Donations List</title>
    <?php echo $__env->make('user.headlink', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <link rel="stylesheet" href="https://cdn.datatables.net/1.13.7/css/jquery.dataTables.min.css">
    <style>
        .badge-success { background-color: #28a745; }
        .badge-pending { background-color: #ffc107; color: #212529; }
        .badge-failed { background-color: #dc3545; }
        .action-btns { display: flex; gap: 8px; }
        .btn-view { background-color: #17a2b8; color: white; padding: 6px 12px; border: none; border-radius: 4px; }
        .btn-download { background-color: #28a745; color: white; padding: 6px 12px; border: none; border-radius: 4px; }
    </style>
</head>
<body>
    <?php echo $__env->make('admin.head_sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <div class="content">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-12">
                    <div class="card shadow mb-4 animate__animated animate__fadeIn">
                        <div class="card-header py-3 d-flex justify-content-between align-items-center">
                            <h1 class="h3 mb-0 text-gray-800">All Donations</h1>
                        </div>
                        <div class="card-body">
                            <div class="table-responsive">
                                <table class="table table-bordered" id="donationsTable" width="100%" cellspacing="0">
                                    <thead>
                                        <tr>
                                            <th>#</th>
                                            <th>Transaction ID</th>
                                            <th>Donor Name</th>
                                            <th>Amount</th>
                                            <th>Payment Method</th>
                                            <th>Status</th>
                                            <th>Date</th>
                                            <th>Actions</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $__currentLoopData = $donations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $donation): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td><?php echo e($index + 1); ?></td>
                                            <td><?php echo e($donation->transaction_id); ?></td>
                                            <td><?php echo e($donation->name); ?></td>
                                            <td>₹<?php echo e(number_format($donation->amount, 2)); ?></td>
                                            <td><?php echo e(ucfirst($donation->payment_gateway)); ?></td>
                                            <td>
                                                <?php if($donation->status == 'completed'): ?>
                                                    <span class="badge badge-success">Completed</span>
                                                <?php elseif($donation->status == 'pending'): ?>
                                                    <span class="badge badge-pending">Pending</span>
                                                <?php else: ?>
                                                    <span class="badge badge-failed">Failed</span>
                                                <?php endif; ?>
                                            </td>
                                            <td><?php echo e($donation->created_at->format('d-m-Y H:i')); ?></td>
                                            <td class="action-btns">
                                                <a href="<?php echo e(route('admin.donations.show', $donation->id)); ?>" class="btn-view">
                                                    <i class="fas fa-eye"></i>
                                                </a>
                                                <?php if($donation->status == 'completed'): ?>
                                                <a href="<?php echo e(route('admin.donations.download', $donation->id)); ?>" class="btn-download">
                                                    <i class="fas fa-download"></i> 
                                                </a>
                                                <?php endif; ?>
                                            </td>
                                        </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
    <script src="https://cdn.datatables.net/1.13.7/js/jquery.dataTables.min.js"></script>
    <script>
        $(document).ready(function() {
            $('#donationsTable').DataTable({
                paging: true,
                searching: true,
                ordering: true,
                info: true,
                order: [[6, 'desc']] // Sort by date descending
            });
        });
    </script>
</body>
</html>
<?php /**PATH /home1/jertabhumanity/public_html/resources/views/admin/donations/index.blade.php ENDPATH**/ ?>