<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Login - Donation System</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Marcellus&family=Maven+Pro:wght@400;500;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/animate.css/4.1.1/animate.min.css">
    <style>
        :root {
            --primary-color: #4a148c; /* Different purple shade for admin */
            --secondary-color: #ff6d00;
            --accent-color: #00c853;
        }

        body {
            font-family: 'Maven Pro', sans-serif;
            background-color: #f8f9fa;
            height: 100vh;
            display: flex;
            align-items: center;
            background: linear-gradient(135deg, rgba(248,249,250,1) 0%, rgba(222,226,230,1) 100%);
            overflow: hidden;
        }

        .admin-card {
            border-radius: 15px;
            box-shadow: 0 10px 30px rgba(0,0,0,0.1);
            overflow: hidden;
            border: none;
            z-index: 2;
            position: relative;
            max-width: 500px;
            margin: 0 auto;
        }

        .admin-card-header {
            background: linear-gradient(135deg, var(--primary-color) 0%, #7b1fa2 100%);
            color: white;
            padding: 1.5rem;
            text-align: center;
            border-bottom: none;
        }

        .admin-card-header h3 {
            font-family: 'Marcellus', serif;
            margin: 0;
            font-size: 1.8rem;
        }

        .admin-card-body {
            padding: 2rem;
            background: white;
        }

        .form-label {
            font-weight: 500;
            color: #495057;
        }

        .form-control {
            border-radius: 8px;
            padding: 10px 15px;
            border: 1px solid #ced4da;
            transition: all 0.3s;
        }

        .form-control:focus {
            border-color: var(--primary-color);
            box-shadow: 0 0 0 0.25rem rgba(74, 20, 140, 0.25);
        }

        .btn-admin {
            background: linear-gradient(135deg, var(--primary-color) 0%, #7b1fa2 100%);
            border: none;
            padding: 12px;
            font-weight: 500;
            border-radius: 8px;
            transition: all 0.3s;
            color: white;
            width: 100%;
        }

        .btn-admin:hover {
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(74, 20, 140, 0.3);
            color: white;
        }

        .alert-danger {
            background-color: #ffebee;
            border-color: #ef9a9a;
            color: #c62828;
            border-radius: 8px;
            padding: 10px 15px;
            margin-bottom: 20px;
        }

        .text-center h4 {
            font-family: 'Marcellus', serif;
            color: var(--primary-color);
            font-size: 1.8rem;
            margin-bottom: 0.5rem;
        }

        .text-center p {
            color: #6c757d;
            margin-bottom: 1.5rem;
        }
    </style>
</head>
<body>
    <div class="container py-5">
        <div class="row justify-content-center">
            <div class="col-md-8 col-lg-6">
                <div class="admin-card shadow-lg animate__animated animate__fadeIn">
                    <div class="admin-card-header">
                        <h3>Admin Portal</h3>
                    </div>
                    <div class="admin-card-body">
                        <div class="text-center mb-4">
                            <img width="70px;" src="<?php echo e(asset('home/logo2.png')); ?>" alt="Logo" class="mb-3">
                            <h4>Administrator Access</h4>
                            <p>Restricted access - authorized personnel only</p>
                        </div>

                        <?php if($errors->any()): ?>
                            <div class="alert alert-danger animate__animated animate__shakeX">
                                <?php echo e($errors->first()); ?>

                            </div>
                        <?php endif; ?>

                        <form method="POST" action="<?php echo e(route('admin.login')); ?>">
                            <?php echo csrf_field(); ?>
                            <div class="mb-3">
                                <label for="email" class="form-label">Admin Email</label>
                                <input type="email" class="form-control" id="email" name="email" required autofocus>
                            </div>
                            <div class="mb-3">
                                <label for="password" class="form-label">Password</label>
                                <input type="password" class="form-control" id="password" name="password" required>
                            </div>
                            <div class="d-grid gap-2">
                                <button type="submit" class="btn btn-admin">Login</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
<?php /**PATH /home1/jertabhumanity/public_html/resources/views/admin/login.blade.php ENDPATH**/ ?>