<!DOCTYPE html>
<html lang="en">

<meta http-equiv="content-type" content="text/html;charset=UTF-8" />
<head>
     <?php echo $__env->make('googletag', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
   <meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Jertab Humanity | Restoring Dignity & Hope Through Compassion</title>
<meta name="description" content="Jertab Humanity provides food, shelter, financial aid, and resources to those in need, helping rebuild lives and small businesses with kindness and dignity.">
<link rel="shortcut icon" href="<?php echo e(asset('home/logo2.png')); ?>" type="image/x-icon">
    <?php echo $__env->make('header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
</head>

<body class="custom-cursor">
    
  
    <?php echo $__env->make('menu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>


    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/swiper@11/swiper-bundle.min.css" />
    <style>
        .swiper {
            width: 100%;
            max-height: 640px;
            aspect-ratio: 1670 / 640;
            overflow: hidden;
        }

        .swiper-slide {
            position: relative;
            background-size: cover;
            background-position: center;
            height: 100%;
        }

        .banner-text {
            position: absolute;
            bottom: 30px;
            left: 40px;
            color: white;
            background: rgba(0, 0, 0, 0.5);
            padding: 1rem;
            border-radius: 8px;
            max-width: 50%;
        }

        .about-content p {
            text-align: justify;
        }
    </style>
    </head>

    <body>

        <div class="banner-two">
            <div class="container-fluid p-0">
                <div class="banner-slider-two">
                    <?php $__currentLoopData = $banners; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $banner): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="banner-item-two">
                            <div class="banner-box-two">
                                <div class="banner-content-two">
                                    <svg viewBox="0 0 1320 770" xmlns="http://www.w3.org/2000/svg"
                                        style="width: 100%; height: auto;">
                                        <defs>
                                            <clippath id="shapeClip6">
                                                <path
                                                    d="M1320 630C1320 657.614 1297.61 680 1270 680H420.047C405.711 680 392.064 686.154 382.573 696.898L332.927 753.102C323.436 763.846 309.789 770 295.453 770H50C22.3858 770 0 747.614 0 720V150C0 122.386 22.3858 100 50 100H497.64C512.157 100 525.958 93.6903 535.455 82.7105L592.045 17.2895C601.542 6.30973 615.343 0 629.86 0H1270C1297.61 0 1320 22.3858 1320 50V630Z" />
                                            </clippath>
                                        </defs>
                                        <g clip-path="url(#shapeClip6)">
                                            <image href="<?php echo e(asset($banner->image)); ?>" width="1320" height="770"
                                                preserveAspectRatio="xMidYMid slice" />
                                        </g>
                                    </svg>
                                    <div class="banner-top-two">
                                        <h4><?php echo e($banner->description); ?></h4>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                </div>
            </div>
        </div>



        <!-- header end -->
        <!-- banner start -->

        <!-- banner end -->
        <!-- text line start -->

        <!-- text line end -->
        <!-- about start  -->
        <div class="about-section">
            <div class="container">
                <div class="row gutter-y-20">
                    <div class="col-xl-6 col-lg-6 col-md-6 mb-0">
                        <div class="about-content">
                            <div class="heading">
                                <h2 style="margin-bottom: -5px;">Lets Know</h2>
                                <h3
                                    style=" color: transparent;          /* Makes text fill transparent */
  -webkit-text-stroke: 1px black;
  text-stroke: 1px black;
  font-size: 48px;             /* Adjust size as needed */
  font-weight: bold;           /* Makes the outline more visible */
  display: inline-block;       /* For better spacing control */
    font-family: 'Bebas Neue', sans-serif;">
                                    Our History</h3>
                            </div>
                            <p>Jertab Humanity began with a heartfelt mission: to stand beside individuals in real
                                need—on the streets, in camps, or behind closed doors. Our journey has been about
                                reaching out personally, offering food, financial support, shelter, and resources to
                                help people rebuild their lives or start small businesses. Through every act of
                                kindness, we aim to restore dignity and hope. With compassion as our guide, we continue
                                creating meaningful change, one life at a time.</p>


                        </div>
                    </div>
                    <div class="col-xl-6 col-lg-6 col-md-6 mb-0 twoim">
                        <div class="about-image">
                            <svg viewBox="0 0 645 575" xmlns="http://www.w3.org/2000/svg"
                                style="width: 100%; height: auto;">
                                <defs>
                                    <clippath id="shapeClip2">
                                        <path
                                            d="M0 30C0 13.4315 13.4315 0 30 0H239.82C251.256 0 261.696 6.50119 266.742 16.7634L279.758 43.2366C284.804 53.4988 295.244 60 306.68 60H615C631.569 60 645 73.4315 645 90V545C645 561.569 631.569 575 615 575H30C13.4315 575 0 561.569 0 545V30Z" />
                                    </clippath>
                                </defs>
                                <g clip-path="url(#shapeClip2)">
                                    <image href="assets/images/about/home-2.webp" width="645" height="575"
                                        preserveAspectRatio="xMidYMid slice" />
                                </g>
                            </svg>
                            
                        </div>
                        <div class="about-image">
                            <svg viewBox="0 0 645 575" xmlns="http://www.w3.org/2000/svg"
                                style="width: 100%; height: auto;">
                                <defs>
                                    <clippath id="shapeClip2">
                                        <path
                                            d="M0 30C0 13.4315 13.4315 0 30 0H239.82C251.256 0 261.696 6.50119 266.742 16.7634L279.758 43.2366C284.804 53.4988 295.244 60 306.68 60H615C631.569 60 645 73.4315 645 90V545C645 561.569 631.569 575 615 575H30C13.4315 575 0 561.569 0 545V30Z" />
                                    </clippath>
                                </defs>
                                <g clip-path="url(#shapeClip2)">
                                    <image href="assets/images/about/home-1.webp" width="645" height="575"
                                        preserveAspectRatio="xMidYMid slice" />
                                </g>
                            </svg>
                            
                        </div>
                    </div>

                </div>
            </div>
        </div>


        <div class="text-slider-section">
            <div class="container-fluid p-0">
                <div class="text-slider">
                    <div class="text-slider-item">
                        <div class="text-slider-box">
                            <img src="assets/images/text-svg.svg" alt="">
                            <h4>560+ Happy People /</h4>
                        </div>
                    </div>
                    <div class="text-slider-item">
                        <div class="text-slider-box">
                            <img src="assets/images/text-svg.svg" alt="">
                            <h4>1200+ Donation /</h4>
                        </div>
                    </div>
                    <div class="text-slider-item">
                        <div class="text-slider-box">
                            <img src="assets/images/text-svg.svg" alt="">
                            <h4>630+ Mission /</h4>
                        </div>
                    </div>
                    <div class="text-slider-item">
                        <div class="text-slider-box">
                            <img src="assets/images/text-svg.svg" alt="">
                            <h4>200+ Places /</h4>
                        </div>
                    </div>
                    <div class="text-slider-item">
                        <div class="text-slider-box">
                            <img src="assets/images/text-svg.svg" alt="">
                            <h4>560+ Happy People /</h4>
                        </div>
                    </div>

                </div>
            </div>
        </div>
        <!-- about end  -->

        <style>
            .card {
                background: linear-gradient(45deg, #254566, #d0a933, #254566);
                /* background-size: 200% 200%; */
                box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
                overflow: hidden;
                text-align: center;
                padding: 7px;
                border-radius: 10px;
                position: relative;
                transition: transform 0.3s ease, box-shadow 0.3s ease;
                animation: gradientFlow 8s ease infinite;
            }


            .card:hover {
                background: linear-gradient(45deg, #d0a933, #254566, #d0a933);
                transform: translateY(-10px);
                box-shadow: 8px 8px 16px rgba(0, 0, 0, 0.2);
            }

            /* Overlay to ensure text readability */
            .card::before {
                content: '';
                position: absolute;
                top: 0;
                left: 0;
                width: 100%;
                height: 100%;
                /* background: rgba(255, 255, 255, 0.9); */
                z-index: 1;
            }

            .card-content {
                background-color: rgb(250, 250, 250);
                padding: 15px;
                border-radius: 90px;
                position: relative;
                z-index: 2;
            }

            .card-icon {
                font-size: 3em;
                color: #e67e22;
                margin-bottom: 15px;
            }

            .card h2 {
                font-size: 1.8em;
                color: #2c3e50;
                margin-bottom: 10px;
            }

            .card p {
                font-size: 1em;
                color: #7f8c8d;
                line-height: 1.6;
                padding: 0 10px;
            }

            .ssos {
                scale: 1;
                transition: .4s;
            }

            .os:hover .ssos {
                scale: 1.2;
            }
        </style>

        <div style="margin-top:40px;" class="shows-section">
            <div class="container">
                <div class="heading-box text-center">
                    <h2>Our Services</h2>
                </div>
                <div class="row gutter-y-30 justify-content-center">
                    <div class="col-xl-4 col-lg-6 col-md-6">
                        <div class="card os">
                            <div class="card-content">
                                <div class="card-icon"> <img class="ssos" width="80px"
                                        src="<?php echo e(asset('home/iftar.png')); ?>" alt=""></div>
                                <h2>Feeding Hope</h2>
                                <p>Jertab Humanity offers warm, nutritious meals to those living on the streets and in
                                    struggling conditions, ensuring they are not forgotten. Every meal served is a step
                                    toward dignity, care, and renewed strength.</p>
                            </div>
                        </div>
                    </div>

                    <div class="col-xl-4 col-lg-6 col-md-6">
                        <div class="card os">
                            <div class="card-content">
                                <div class="card-icon"> <img class="ssos" width="80px"
                                        src="<?php echo e(asset('home/education.png')); ?>" alt=""></div>
                                <h2>Educating Hope</h2>
                                <p>Jertab Humanity supports underprivileged children by offering free learning support,
                                    mentorship, and personal guidance—helping them overcome challenges, gain confidence,
                                    and pursue a brighter future.</p>
                            </div>
                        </div>
                    </div>

                    <div class="col-xl-4 col-lg-6 col-md-6">
                        <div class="card os">
                            <div class="card-content">
                                <div class="card-icon"> <img class="ssos" width="80px"
                                        src="<?php echo e(asset('home/shelter.png')); ?>" alt=""></div>
                                <h2>Shelter Hope</h2>
                                <p>Jertab Humanity provides safe shelter and emotional support to individuals living in
                                    difficult conditions—offering not just a roof, but a renewed sense of hope, comfort,
                                    and stability.</p>
                            </div>
                        </div>
                    </div>

                    <div class="col-xl-4 col-lg-6 col-md-6">
                        <div class="card os">
                            <div class="card-content">
                                <div class="card-icon"><img class="ssos" width="80px"
                                        src="<?php echo e(asset('home/financial.png')); ?>" alt=""></div>
                                <h2>Financial Uplift</h2>
                                <p>Jertab Humanity offers financial assistance to struggling individuals and
                                    families—helping them meet urgent needs, start small businesses, or rebuild their
                                    lives with dignity and independence.</p>
                            </div>
                        </div>
                    </div>

                    <div class="col-xl-4 col-lg-6 col-md-6">
                        <div class="card os">
                            <div class="card-content">
                                <div class="card-icon"><img class="ssos" width="80px"
                                        src="<?php echo e(asset('home/caring-people.png')); ?>" alt=""></div>
                                <h2>Caring People</h2>
                                <p>Jertab Humanity reaches out with compassion to those in distress—offering a listening
                                    ear, emotional support, and a helping hand. We stand with people in pain, reminding
                                    them they are not alone.</p>
                            </div>
                        </div>
                    </div>

                </div>
            </div>
        </div>



        <!-- shows start  -->
        <div style="margin-top:40px;" class="shows-section">
            <div class="container">
                <div class="heading-box text-center">
                    <h2>Highlight Videos</h2>
                </div>

                <div class="row gutter-y-30">
                    <?php $__currentLoopData = $videos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $video): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="col-xl-4 col-lg-6 col-md-6">

                            <?php if($video->youtube_id): ?>
                                <div class="show-box" onclick="openVideoModal('<?php echo e($video->youtube_id); ?>')">
                                    <div class="show-image">
                                        <style>
                                            .videoimg {
                                                height: 350px !important;
                                                object-fit: cover;
                                            }
                                        </style>
                                        <img src="https://img.youtube.com/vi/<?php echo e($video->youtube_id); ?>/mqdefault.jpg"
                                            alt="<?php echo e($video->heading); ?>" class="videoimg">
                                        <div class="show-content">
                                            <svg width="420" height="100" viewBox="0 0 420 100" fill="none"
                                                xmlns="http://www.w3.org/2000/svg">
                                                <path
                                                    d="M0 20C0 8.9543 8.95431 0 20 0H297.88C309.798 0 320.587 7.05582 325.364 17.9754L335.886 42.0246C340.663 52.9442 351.452 60 363.37 60H400C411.046 60 420 68.9543 420 80V158C420 174.569 406.569 188 390 188H30C13.4315 188 0 174.569 0 158V20Z"
                                                    fill="white" />
                                            </svg>
                                            <div class="show-content-inner">
                                                <ul>
                                                    <li>
                                                        <i style="margin-top:3px;" class='fas fa-calendar-alt'></i>
                                                        <?php echo e(\Carbon\Carbon::parse($video->date_time)->format('M d, Y')); ?>

                                                    </li>
                                                </ul>
                                                <h4><a href="podcast-details.html"><?php echo e($video->heading); ?></a></h4>
                                                <div class="show-audio-box audio-player">
                                                    <p>When Humatiny gives you that tiny hug and suddenly all your
                                                        stress melts away all your stress melts away</p>
                                                </div>
                                            </div>
                                            <!-- Updated Share Button -->
                                            <a href="#" class="show-share-btn"
                                                onclick="shareVideo('<?php echo e($video->youtube_id); ?>', '<?php echo e($video->heading); ?>', event)">
                                                <img src="assets/images/Share.svg" alt="Share">
                                            </a>
                                        </div>
                                    </div>
                                </div>
                            <?php endif; ?>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>


                </div>
            </div>
        </div>



        <div style="margin-top:40px;padding-bottom:40px;" class="shows-section">
            <div class="container">
                <div style="margin-bottom: 30px;" class="heading-box text-center">
                    <h2 style="margin-bottom: -5px;">our statistics</h2>
                    <h3
                        style=" color: transparent;          /* Makes text fill transparent */
  -webkit-text-stroke: 1px black;
  text-stroke: 1px black;
  font-size: 48px;             /* Adjust size as needed */
  font-weight: bold;           /* Makes the outline more visible */
  display: inline-block;       /* For better spacing control */
    font-family: 'Bebas Neue', sans-serif;">
                        We Provide Help</h3>
                </div>

                <div class="row gutter-y-30">



                </div>
            </div>
        </div>



        <!-- The Modal -->
        <div id="videoModal" class="modal">
            <div class="modal-content">
                <span class="close" onclick="closeModal()">&times;</span>
                <div class="video-wrapper">
                    <iframe id="youtubeFrame" width="560" height="315" frameborder="0"
                        allowfullscreen></iframe>
                </div>
            </div>
        </div>
        <script>
            function openVideoModal(videoId) {
                const modal = document.getElementById('videoModal');
                const iframe = document.getElementById('youtubeFrame');
                iframe.src = `https://www.youtube.com/embed/${videoId}?autoplay=1`;
                modal.style.display = "block";
                document.body.style.overflow = "hidden"; // Prevent page scrolling
            }

            function closeModal() {
                const modal = document.getElementById('videoModal');
                const iframe = document.getElementById('youtubeFrame');
                iframe.src = '';
                modal.style.display = "none";
                document.body.style.overflow = "auto";
            }

            // Close when clicking outside modal
            window.onclick = function(event) {
                const modal = document.getElementById('videoModal');
                if (event.target == modal) {
                    closeModal();
                }
            }

            // Share video function
            function shareVideo(videoId, videoHeading, event) {
                event.stopPropagation(); // Prevent event from bubbling up
                event.preventDefault(); // Prevent default anchor behavior

                const videoUrl = `https://www.youtube.com/watch?v=${videoId}`;
                const shareData = {
                    title: videoHeading,
                    url: videoUrl
                };

                // Rest of your share function remains the same
                if (navigator.share) {
                    navigator.share(shareData)
                        .then(() => console.log('Video shared successfully'))
                        .catch((error) => console.error('Error sharing video:', error));
                } else {
                    navigator.clipboard.writeText(videoUrl)
                        .then(() => {
                            alert('Video URL copied to clipboard: ' + videoUrl);
                        })
                        .catch((error) => {
                            console.error('Error copying URL:', error);
                            alert('Failed to copy URL. Please copy manually: ' + videoUrl);
                        });
                }
            }
        </script>


        <style>
            /* Video Grid */
            .show-share-btn {
                transition: opacity 0.3s;
            }

            .show-share-btn:hover {
                opacity: 0.8;
            }

            .video-card {
                position: relative;
                cursor: pointer;
                transition: transform 0.3s;
            }

            .video-card:hover {
                transform: scale(1.03);
            }



            /* Modal Styles */
            .modal {
                display: none;
                position: fixed;
                z-index: 100;
                left: 0;
                top: 0;
                width: 100%;
                height: 100%;
                background-color: rgba(0, 0, 0, 0.9);
            }

            .modal-content {
                position: relative;
                margin: auto;
                padding: 20px;
                width: 80%;
                max-width: 900px;
                top: 50%;
                transform: translateY(-50%);
            }

            .video-wrapper {
                position: relative;
                padding-bottom: 56.25%;
                /* 16:9 Aspect Ratio */
                height: 0;
            }

            .video-wrapper iframe {
                position: absolute;
                top: 0;
                left: 0;
                width: 100%;
                height: 100%;
            }

            .close {
                position: absolute;
                right: 25px;
                top: 10px;
                color: white;
                font-size: 35px;
                font-weight: bold;
                cursor: pointer;
            }

            .btnvideo {
                border: 2px dashed #000;
                border-radius: 20px;
                padding: 10px 20px;
                margin: 10px;
                transition: .5s;
            }

            .blog-box1:hover .btnvideo {
                margin-left: 20px;
                border: 2px solid #c9c9c9;
            }

            .blog-box1 {
                padding: 10px;
                border: 2px solid #c9c9c9;
                transition: .1s;
                border-radius: 20px;
            }

            .blog-box1:hover {
                box-shadow: 3px 3px 8px #c9c9c9;
            }

            .imagefooter {
                display: flex;
                justify-content: end;
            }

            .imagefooter img {
                margin-right: 20px;
                width: 30px;

            }
        </style>





        <style>
            .hero-container {
                position: relative;
                background-image: url('home/bannerdonate.png');
                background-size: cover;
                background-position: center;

            }

            .hero-overlay {
                position: absolute;
                top: 0;
                left: 0;
                width: 100%;
                height: 100%;
                background-color: rgba(0, 0, 0, 0.1);
            }

            .stat-box {
                background-color: rgba(255, 255, 255, 0.144);
                border-radius: 0.5rem;
                padding: 3rem 1rem;
                height: 100%;


                transition: transform 0.3s ease;
                box-shadow: 0 0.25rem 0.5rem rgba(0, 0, 0, 0.1);
            }

            .stat-box img {
                width: 80px;
                filter:
                    drop-shadow(2px 2px 4px #fff) drop-shadow(2px 2px 4px #fff) drop-shadow(2px 2px 4px #fff);
            }

            .stat-box:hover {
                transform: translateY(-0.5rem);
                box-shadow: -2px -2px 10px #fff;
            }

            .stat-count {
                font-size: 2.5rem;
                font-weight: 700;

                color: #ffffff;
                margin-top: 2rem;
                margin-bottom: 0rem;
            }

            .stat-text {
                color: #ffffff;
            }
        </style>

        <div class="hero-container">
            <div class="hero-overlay"></div>
            <div class="container position-relative z-1 py-4">
                <div class="row g-4">
                    <div class="col-md-6 col-lg-3">
                        <div class="stat-box text-center">
                            <img src="<?php echo e(asset('home/family.png')); ?>" alt="">
                            <h2 class="stat-count">560+</h2>
                            <p class="stat-text">Happy People</p>
                        </div>
                    </div>
                    <div class="col-md-6 col-lg-3">
                        <div class="stat-box text-center">
                            <img src="<?php echo e(asset('home/donation.png')); ?>" alt="">
                            <h2 class="stat-count">1200+</h2>
                            <p class="stat-text">Donation</p>
                        </div>
                    </div>
                    <div class="col-md-6 col-lg-3">
                        <div class="stat-box text-center">
                            <img src="<?php echo e(asset('home/goal.png')); ?>" alt="">
                            <h2 class="stat-count">620+</h2>
                            <p class="stat-text">Mission</p>
                        </div>
                    </div>
                    <div class="col-md-6 col-lg-3">
                        <div class="stat-box text-center">
                            <img src="<?php echo e(asset('home/places.png')); ?>" alt="">
                            <h2 class="stat-count">26+</h2>
                            <p class="stat-text">Places</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>


        <div class="blog-section">
            <div class="container">
                <div class="row">
                    <div class="col-lg-7 m-auto">
                        <div class="heading-box text-center">
                            <h2>LATEST VIDEOS</h2>
                            
                        </div>
                    </div>
                </div>
                <div class="row gutter-y-20">
                    <?php $__currentLoopData = $latestvideos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $video): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="col-xl-4 col-lg-6 col-md-6">
                            <div class="blog-box blog-box1" onclick="openVideoModal('<?php echo e($video->youtube_id); ?>')">
                                <div class="blog-image">
                                    <svg viewBox="0 0 420 308" xmlns="http://www.w3.org/2000/svg"
                                        style="width: 100%; height: auto;">
                                        <defs>
                                            <clippath id="shapeClip5">
                                                <path
                                                    d="M0 288C0 299.046 8.95431 308 20 308H362.773C373.711 308 382.621 299.212 382.771 288.275L383.586 228.91C383.687 221.571 387.799 214.878 394.3 211.47L409.285 203.616C415.872 200.163 420 193.34 420 185.902V20C420 8.9543 411.046 0 400 0H338H304H20C8.9543 0 0 8.95431 0 20V288Z" />
                                            </clippath>
                                        </defs>
                                        <g clip-path="url(#shapeClip5)">
                                            <?php if($video->youtube_id): ?>
                                                <image style="box-shadow: 2px 2px red;"
                                                    href="https://img.youtube.com/vi/<?php echo e($video->youtube_id); ?>/mqdefault.jpg"
                                                    width="420" height="308"
                                                    preserveAspectRatio="xMidYMid slice" />
                                            <?php else: ?>
                                                <image href="assets/images/blog/blog-1.png" width="420"
                                                    height="308" preserveAspectRatio="xMidYMid slice" />
                                            <?php endif; ?>
                                        </g>
                                    </svg>
                                    <a href="#"
                                        class="meda-date"><?php echo e(\Carbon\Carbon::parse($video->date_time)->format('d M')); ?></a>
                                </div>
                                <div class="blog-details">
                                    <a href="#" class="meta-category"><img src="assets/images/svg/Hash.svg"
                                            alt="">Video</a>
                                    <h4><a href="javascript:void(0)"><?php echo e($video->heading); ?></a></h4>
                                    
                                    <a href="javascript:void(0)" class="blog-btn btnvideo"
                                        onclick="openVideoModal('<?php echo e($video->youtube_id); ?>'); return false;">
                                        WATCH NOW <img src="assets/images/btn-icon.svg" alt="icon">
                                    </a>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                </div>
            </div>


            <div class="container gly">
                <div class="heading-box text-center">
                    <h2>Gallery</h2>
                    
                </div>
                <div class="row p-0">
                    <!-- Image 1 -->
                    <div class="col-6 col-md-3  p-0">
                        <div class="image-card position-relative">
                            <img src="<?php echo e(asset('home/neew7.webp')); ?>" alt="Image 1" class="img-fluid">
                            <div class="image-overlay d-flex flex-column justify-content-end align-items-start">
                                

                            </div>
                        </div>
                    </div>

                    <div class="col-6 col-md-3  p-0">
                        <div class="image-card position-relative">
                            <img src="<?php echo e(asset('home/neew8.webp')); ?>" alt="Image 1" class="img-fluid">
                            <div class="image-overlay d-flex flex-column justify-content-end align-items-start">
                                

                            </div>
                        </div>
                    </div>

                    <div class="col-6 col-md-3  p-0">
                        <div class="image-card position-relative">
                            <img src="<?php echo e(asset('home/neew1.webp')); ?>" alt="Image 1" class="img-fluid">
                            <div class="image-overlay d-flex flex-column justify-content-end align-items-start">
                                

                            </div>
                        </div>
                    </div>

                    <div class="col-6 col-md-3  p-0">
                        <div class="image-card position-relative">
                            <img src="<?php echo e(asset('home/neew2.webp')); ?>" alt="Image 1" class="img-fluid">
                            <div class="image-overlay d-flex flex-column justify-content-end align-items-start">
                                

                            </div>
                        </div>
                    </div>

                    <div class="col-6 col-md-3  p-0">
                        <div class="image-card position-relative">
                            <img src="<?php echo e(asset('home/neew4.webp')); ?>" alt="Image 1" class="img-fluid">
                            <div class="image-overlay d-flex flex-column justify-content-end align-items-start">
                                

                            </div>
                        </div>
                    </div>

                    <div class="col-6 col-md-3  p-0">
                        <div class="image-card position-relative">
                            <img src="<?php echo e(asset('home/neew3.webp')); ?>" alt="Image 1" class="img-fluid">
                            <div class="image-overlay d-flex flex-column justify-content-end align-items-start">
                                

                            </div>
                        </div>
                    </div>
                    <div class="col-6 col-md-3  p-0">
                        <div class="image-card position-relative">
                            <img src="<?php echo e(asset('home/neew6.webp')); ?>" alt="Image 1" class="img-fluid">
                            <div class="image-overlay d-flex flex-column justify-content-end align-items-start">
                                

                            </div>
                        </div>
                    </div>

                    <div class="col-6 col-md-3  p-0">
                        <div class="image-card position-relative">
                            <img src="<?php echo e(asset('home/neew5.webp')); ?>" alt="Image 1" class="img-fluid">
                            <div class="image-overlay d-flex flex-column justify-content-end align-items-start">
                                

                            </div>
                        </div>
                    </div>

                    <!-- Continue with images 3-8 following the same pattern -->

                </div>
            </div>

            <style>
                .image-card {
                    position: relative;
                    overflow: hidden;
                }

                .image-overlay {
                    position: absolute;
                    top: 0;
                    left: 0;
                    right: 0;
                    bottom: 0;
                    /* background-color: rgba(0, 0, 0, 0.5); */
                    background: linear-gradient(270deg, #274868ad 0%, #d4b24c67 100%);
                    opacity: 1;
                    transition: opacity 0.3s ease;
                    padding: 10px;
                    text-align: center;
                }
            </style>
        </div>
        <!-- blog end  -->
        <!-- footer start  -->
        <?php echo $__env->make('footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <!-- footer end  -->
        <!-- mobail-menu start  -->

        <!-- mobail-menu end  -->
        <!-- top to bottom  -->

    </body>

    <!-- Mirrored from thegenius.co/html/podup/index.html by HTTrack Website Copier/3.x [XR&CO'2014], Mon, 09 Jun 2025 08:49:23 GMT -->

</html>
<?php /**PATH /home1/jertabhumanity/public_html/resources/views/index.blade.php ENDPATH**/ ?>